"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const controller_1 = require("kdweb-core/lib/mongo/controller");
const controller_2 = require("kdweb-core/lib/redis/controller");
const ServerConfig_1 = require("../../kds-base-define/src/ServerConfig");
const config_1 = require("./config");
let dbs = new Map();
var DB;
(function (DB) {
    function get(dbName, tag) {
        tag = tag || dbName;
        if (dbs.has(tag)) {
            return dbs.get(tag);
        }
        let db = new controller_1.mongoDB(dbName, ServerConfig_1.ServerValues.dbConnectStr);
        dbs.set(tag, db);
        return db;
    }
    DB.get = get;
    DB.redis = new controller_2.redisDB(config_1.Config.redisConfig.host, config_1.Config.redisConfig.port, config_1.Config.redisConfig.auth);
})(DB = exports.DB || (exports.DB = {}));
