"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("kdweb-core/lib/utils");
const ServerConfig_1 = require("../../../kds-base-define/src/ServerConfig");
const TeaConst_1 = require("../../../kds-base-define/src/TeaConst");
const TeaDefine_1 = require("../../../kds-base-define/src/TeaDefine");
const billUtils_1 = require("../billUtils");
const config_1 = require("../config");
const db_1 = require("../db");
const log_1 = require("../log");
const LooperBase_1 = require("./LooperBase");
let aday = 24 * 3600000;
let teaFundTablename = "t_tea_fund_daily_bill";
function getTeaRecordTableName(teaID, recordName) {
    return "t_record_" + recordName + "_" + teaID;
}
class TeaFundBillLooper extends LooperBase_1.LooperBase {
    getTimeCacheName() {
        return "fund-loop-prev-time";
    }
    getUpdateInterval() {
        return 60000;
    }
    getTargetTimeWithConfig() {
        return config_1.Config.localConfig.tea.fundLoopTime || 2;
    }
    /**
     * 生成据今几天前的数据
     * 0就是今天时间点之前一天的数据
     * @param lastCount [0~any)
     */
    workWithLastDay(lastCount) {
        return __awaiter(this, void 0, void 0, function* () {
            lastCount = lastCount != null ? lastCount : 0;
            log_1.Log.oth.info("[tea-proxy-fund] start looper");
            let startTime = this.getTodayTimeTarget() - lastCount * aday;
            let endTime = startTime - aday;
            let db = db_1.DB.get("tds-tea-record", "tea-record");
            let dbBill = db_1.DB.get(ServerConfig_1.ServerValues.dbBill, "tea-fund-proxy-bill-looper");
            let redis = db_1.DB.redis;
            let teaDatas = yield redis.hgetall("t_tea_data", true);
            let teaIDs = Object.keys(teaDatas);
            log_1.Log.oth.info("[tea-proxy-fund] tea count = " + teaIDs.length);
            let templateNameDict = new Map();
            for (let key of teaIDs) {
                log_1.Log.oth.info("[tea-user-bill] teaID = " + key);
                let teaData = teaDatas[key];
                //let teaMember:TeaDefine.TeaMember = await redis.hget("t_tea_member",key,true)
                //let teaTemplate:TeaDefine.TeaTemplate = await redis.hget("t_tea_template",key,true)
                let tableName = getTeaRecordTableName(teaData.teaID, TeaConst_1.TeaConst.RecordAccount);
                let records = yield db.get(tableName, {
                    teaID: teaData.teaID,
                    timestamp: {
                        $gte: endTime,
                        $lt: startTime,
                    }
                });
                if (records == null) {
                    log_1.Log.oth.error("[tea-proxy-fund] cannot get records teaID = " + key);
                    continue;
                }
                let ret = {
                    teaID: teaData.teaID,
                    items: [],
                    // 前一天的日期
                    timestamp: endTime,
                    // 前一天的日期
                    date: utils_1.kdutils.getFmtMoment("YYYY-MM-DD", endTime),
                };
                for (let record of records) {
                    if (record.type != TeaDefine_1.TeaDefine.TeaUserAccountChangedType.CostEarn) {
                        continue;
                    }
                    let templateID = -1;
                    if (typeof (record.from) == "string" && record.from.includes("|")) {
                        let arr = record.from.split("|");
                        let strUserID = arr[0];
                        let strTemplateID = arr[1];
                        templateID = Number.parseInt(strTemplateID);
                        if (Number.isNaN(templateID)) {
                            templateID = -1;
                        }
                    }
                    let item = ret.items.find(v => v.userID == record.userID);
                    if (item == null) {
                        item = {
                            userID: record.userID,
                            templateItems: [],
                        };
                        ret.items.push(item);
                    }
                    let templateItem = item.templateItems.find(v => v.templateID == templateID);
                    if (templateItem == null) {
                        let name = null;
                        if (templateID >= 0) {
                            if (templateNameDict.has(templateID)) {
                                name = templateNameDict.get(templateID);
                            }
                            else {
                                name = (yield redis.hget("t_tea_template_name", templateID.toString())) || null;
                                templateNameDict.set(templateID, name);
                            }
                        }
                        templateItem = {
                            templateID: templateID,
                            name: name,
                            count: 0,
                            cost: 0,
                        };
                        item.templateItems.push(templateItem);
                    }
                    templateItem.count++;
                    templateItem.cost += record.num;
                }
                let count = yield dbBill.delMany(teaFundTablename, {
                    teaID: ret.teaID,
                    date: ret.date
                });
                log_1.Log.oth.info("[tea-proxy-fund] del teaID = " + ret.teaID + " date =" + ret.date + " count = " + count);
                yield dbBill.insert(teaFundTablename, ret);
            }
        });
    }
}
exports.TeaFundBillLooper = TeaFundBillLooper;
let cache = new Map();
function getCacheKey(teaID, date) {
    return teaID + "|" + date;
}
(function (TeaFundBillLooper) {
    TeaFundBillLooper.instance = null;
    function start() {
        TeaFundBillLooper.instance = new TeaFundBillLooper();
    }
    TeaFundBillLooper.start = start;
    /**
     *
     * @param teaID
     * @param lastCount [0~any)
     */
    function getPrevDateBill(teaID, lastCount) {
        return __awaiter(this, void 0, void 0, function* () {
            let time = utils_1.kdutils.getMillionSecond();
            time -= aday * (lastCount + 1);
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD", time);
            let key = getCacheKey(teaID, date);
            if (cache.has(key)) {
                return cache.get(key);
            }
            let db = billUtils_1.BillUtils.dbBill;
            let ret = yield db.getSingle(teaFundTablename, {
                teaID: teaID,
                date: date
            });
            if (ret) {
                cache.set(key, ret);
            }
            return ret;
        });
    }
    TeaFundBillLooper.getPrevDateBill = getPrevDateBill;
})(TeaFundBillLooper = exports.TeaFundBillLooper || (exports.TeaFundBillLooper = {}));
