"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const wcore = require("kdweb-core");
const config_1 = require("./config");
const log_1 = require("./log");
const TeaFundBillLooper_1 = require("./looper/TeaFundBillLooper");
const TeaUserBillLooper_1 = require("./looper/TeaUserBillLooper");
const rpc_1 = require("./rpc");
let app = new wcore.service.entity(config_1.Config.myConfig.servicePort);
app.listen();
rpc_1.Rpc.init();
if (config_1.Config.localConfig.tea) {
    let tea = config_1.Config.localConfig.tea;
    if (tea.fundDailyBillEnabled) {
        log_1.Log.oth.info("start looper: fund bill");
        TeaFundBillLooper_1.TeaFundBillLooper.start();
    }
    if (tea.userDailyBillEnabled) {
        log_1.Log.oth.info("start looper: user bill");
        TeaUserBillLooper_1.TeaUserBillLooper.start();
    }
}
