"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const billUtils_1 = require("../billUtils");
const log_1 = require("../log");
var BillCursor;
(function (BillCursor) {
    function getUserBill(userID, cursor, timestamp) {
        return __awaiter(this, void 0, void 0, function* () {
            let db = billUtils_1.BillUtils.dbBill;
            let tableName = billUtils_1.BillUtils.billTablename;
            let kv = {
                users: { $elemMatch: { userID: userID } },
            };
            if (timestamp) {
                kv.startDate = billUtils_1.BillUtils.getDate(timestamp);
            }
            let ret = yield getCursor(db, tableName, kv, cursor, {
                sort: { startTimestamp: -1 }
            });
            if (ret == null) {
                log_1.Log.oth.error("[cursor] getUserBill: db get cursor failed userID = " + userID);
            }
            return ret;
        });
    }
    BillCursor.getUserBill = getUserBill;
    function getTeaBill(teaID, cursor, timestamp) {
        return __awaiter(this, void 0, void 0, function* () {
            let db = billUtils_1.BillUtils.dbBill;
            let tableName = billUtils_1.BillUtils.billTablename;
            let kv = {
                "roomPOData.roomData.teaExt.teaID": teaID,
            };
            if (timestamp) {
                kv.startDate = billUtils_1.BillUtils.getDate(timestamp);
            }
            let ret = yield getCursor(db, tableName, kv, cursor, {
                sort: { startTimestamp: -1 }
            });
            if (ret == null) {
                log_1.Log.oth.error("[cursor] getTeaBill: db get cursor failed teaID = " + teaID);
            }
            return ret;
        });
    }
    BillCursor.getTeaBill = getTeaBill;
    function getTeaUserBill(teaID, userID, cursor, timestamp) {
        return __awaiter(this, void 0, void 0, function* () {
            let db = billUtils_1.BillUtils.dbBill;
            let tableName = billUtils_1.BillUtils.billTablename;
            let kv = {
                "roomPOData.roomData.teaExt.teaID": teaID,
                users: { $elemMatch: { userID: userID } },
            };
            if (timestamp) {
                kv.startDate = billUtils_1.BillUtils.getDate(timestamp);
            }
            let ret = yield getCursor(db, tableName, kv, cursor, {
                sort: { startTimestamp: -1 }
            });
            if (ret == null) {
                log_1.Log.oth.error("[cursor] getTeaBill: db get cursor failed teaID = " + teaID);
            }
            return ret;
        });
    }
    BillCursor.getTeaUserBill = getTeaUserBill;
    function getCursor(db, tableName, kv, cursor, opt) {
        return __awaiter(this, void 0, void 0, function* () {
            opt = opt || {};
            opt.limit = cursor.count;
            opt.skip = cursor.from;
            if (cursor.top && typeof (cursor.top) == "number") {
                kv.startTimestamp = { $lte: cursor.top };
            }
            kv.juCount = -1;
            let p = yield billUtils_1.BillUtils.dbBill.getCursor(tableName, kv, opt);
            if (p == null) {
                log_1.Log.oth.error("[cursor] getCursor: db get cursor failed tableName = " + tableName);
                return null;
            }
            let ret = {
                cursor: {
                    from: cursor.from,
                    count: cursor.count,
                    max: yield p.entity.count()
                },
                datas: null,
            };
            ret.datas = yield p.entity.toArray();
            if (ret.datas == null) {
                log_1.Log.oth.error("[cursor] getCursor: db toArray failed tableName = " + tableName);
                return null;
            }
            for (let data of ret.datas) {
                delete data["_id"];
            }
            return ret;
        });
    }
    BillCursor.getCursor = getCursor;
})(BillCursor = exports.BillCursor || (exports.BillCursor = {}));
