"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const BillDefine_1 = require("../../../kds-base-define/src/BillDefine");
const rpc_1 = require("../rpc");
const MutexDefine_1 = require("../../../kds-base-define/src/MutexDefine");
const log_1 = require("../log");
const UserDefine_1 = require("../../../kds-base-define/src/UserDefine");
function mutexFunc(userID, func) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let b = yield rpc_1.Rpc.center.callException("kds.mutex.get", MutexDefine_1.MutexDefine.UserGameRecord(userID), 10000);
            if (!b) {
                log_1.Log.oth.info("get mutex failed userID = " + userID);
                return false;
            }
            b = yield func();
            return b;
        }
        catch (error) {
            log_1.Log.oth.error("get mutex failed userID = " + userID + " error = ", error);
        }
        finally {
            yield rpc_1.Rpc.center.call("kds.mutex.release", MutexDefine_1.MutexDefine.UserGameRecord(userID));
        }
        return false;
    });
}
var UserHelper;
(function (UserHelper) {
    function record(data) {
        return __awaiter(this, void 0, void 0, function* () {
            yield mutexFunc(data.userID, function () {
                return __awaiter(this, void 0, void 0, function* () {
                    let groupID = data.groupID || UserDefine_1.UserDefine.CustomGameRecordGroupID;
                    let groupData = yield rpc_1.Rpc.center.callException("kds.dbp.group.get", groupID);
                    if (groupData) {
                        if (groupData.recordGroupID) {
                            groupID = groupData.recordGroupID;
                        }
                    }
                    let record = yield rpc_1.Rpc.center.callException("kds.dbp.user.gamerecord.get", data.userID, groupID);
                    if (record == null) {
                        record = {
                            totalCount: 0,
                            win: 0,
                            lose: 0,
                            draw: 0,
                            escape: 0,
                        };
                    }
                    record.totalCount++;
                    switch (data.status) {
                        case BillDefine_1.BillDefine.UserWinStatus.Win:
                            {
                                record.win++;
                            }
                            break;
                        case BillDefine_1.BillDefine.UserWinStatus.Lose:
                            {
                                record.lose++;
                            }
                            break;
                        case BillDefine_1.BillDefine.UserWinStatus.Draw:
                            {
                                record.draw++;
                            }
                            break;
                    }
                    if (data.escape) {
                        record.escape++;
                    }
                    yield rpc_1.Rpc.center.callException("kds.dbp.user.gamerecord.update", data.userID, groupID, record);
                    let ntData = {
                        groupRecords: [{
                                groupID: groupID,
                                record: record
                            }]
                    };
                    rpc_1.Rpc.center.call("kds.nt.changed.user.gamerecord", data.userID, ntData);
                    return true;
                });
            });
        });
    }
    UserHelper.record = record;
})(UserHelper = exports.UserHelper || (exports.UserHelper = {}));
