"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const db_1 = require("../db");
let redis = db_1.DB.redis;
let loopCacheTablename = "t_bill_looper";
var LoopHelper;
(function (LoopHelper) {
    function getKey(key, json) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield redis.hget(loopCacheTablename, key, json);
        });
    }
    LoopHelper.getKey = getKey;
    function setKey(key, value, json) {
        return __awaiter(this, void 0, void 0, function* () {
            yield redis.hset(loopCacheTablename, key, value, json);
        });
    }
    LoopHelper.setKey = setKey;
    function getNum(key, int) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield redis.hget(loopCacheTablename, key, false);
            if (ret) {
                return int ? Number.parseInt(ret) : Number.parseFloat(ret);
            }
            return null;
        });
    }
    LoopHelper.getNum = getNum;
    function setNum(key, value) {
        return __awaiter(this, void 0, void 0, function* () {
            yield redis.hset(loopCacheTablename, key, value.toString());
        });
    }
    LoopHelper.setNum = setNum;
})(LoopHelper = exports.LoopHelper || (exports.LoopHelper = {}));
