"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const billHelper_1 = require("../../../kds-bill-report/src/helper/billHelper");
function getUserBill(h, userID, startTimestamp, days) {
    return __awaiter(this, void 0, void 0, function* () {
        let bills = yield billHelper_1.BillHelper.getUserBill(userID, startTimestamp, days);
        return bills;
    });
}
function getTeaBill(h, teaID, startTimestamp, days) {
    return __awaiter(this, void 0, void 0, function* () {
        let bills = yield billHelper_1.BillHelper.getTeaBill(teaID, startTimestamp, days);
        return bills;
    });
}
function getFupan(h, fupanID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield billHelper_1.BillHelper.getFupanData(fupanID);
    });
}
function getRoomBills(h, roomID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield billHelper_1.BillHelper.getRoomBills(roomID);
    });
}
exports.RpcUserBillService = {
    get: getUserBill,
};
exports.RpcTeaBillService = {
    get: getTeaBill,
};
exports.RpcFupanService = {
    get: getFupan
};
exports.RpcRoomService = {
    get: getRoomBills
};
