"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const billCursor_1 = require("../../../kds-bill-report/src/helper/billCursor");
function getUserBill(h, userID, cursor, timestamp) {
    return __awaiter(this, void 0, void 0, function* () {
        let data = yield billCursor_1.BillCursor.getUserBill(userID, cursor, timestamp);
        return data;
    });
}
function getTeaBill(h, teaID, cursor, timestamp) {
    return __awaiter(this, void 0, void 0, function* () {
        let data = yield billCursor_1.BillCursor.getTeaBill(teaID, cursor, timestamp);
        let datas = data.datas;
        for (let bill of datas) {
            for (let user of bill.users) {
                delete user.nickName;
                delete user.iconUrl;
            }
        }
        return data;
    });
}
function getTeaUserBill(h, teaID, userID, cursor, timestamp) {
    return __awaiter(this, void 0, void 0, function* () {
        let data = yield billCursor_1.BillCursor.getTeaUserBill(teaID, userID, cursor, timestamp);
        let datas = data.datas;
        for (let bill of datas) {
            for (let user of bill.users) {
                delete user.nickName;
                delete user.iconUrl;
            }
        }
        return data;
    });
}
exports.RpcCursorUserBillService = {
    get: getUserBill,
};
exports.RpcCursorTeaBillService = {
    get: getTeaBill,
    getUser: getTeaUserBill
};
