"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
var TeaHelper;
(function (TeaHelper) {
    function roomCreate(roomPOData) {
        return __awaiter(this, void 0, void 0, function* () {
            if (roomPOData.roomData.teaExt) {
                return yield rpc_1.Rpc.center.callException("kds.tea.pay.roomCreate", roomPOData);
            }
            return false;
        });
    }
    TeaHelper.roomCreate = roomCreate;
    function roomEnd(roomPOData, roomRealtime, bill) {
        return __awaiter(this, void 0, void 0, function* () {
            if (roomPOData.roomData.teaExt) {
                yield rpc_1.Rpc.center.callException("kds.tea.pay.roomEnd", roomPOData, roomRealtime, bill);
                return true;
            }
            return false;
        });
    }
    TeaHelper.roomEnd = roomEnd;
})(TeaHelper = exports.TeaHelper || (exports.TeaHelper = {}));
