"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const MutexDefine_1 = require("../../../kds-base-define/src/MutexDefine");
const log_1 = require("../log");
const utils_1 = require("kdweb-core/lib/utils");
function accountMutexFunc(teaID, userID, func) {
    return __awaiter(this, void 0, void 0, function* () {
        let name = MutexDefine_1.MutexDefine.TeaUserAccount(teaID, userID);
        try {
            let b = yield rpc_1.Rpc.center.callException("kds.mutex.get", name, 10000);
            if (!b) {
                log_1.Log.oth.info("get mutex failed teaID = " + teaID);
                return null;
            }
            let ret = yield func();
            return ret;
        }
        catch (error) {
            log_1.Log.oth.error("get mutex failed name = " + name + " error = ", error);
        }
        finally {
            yield rpc_1.Rpc.center.call("kds.mutex.release", name);
        }
        return null;
    });
}
function accountChanged(h, teaID, userID, count) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!utils_1.kdutils.isValid(teaID, "number")
            || !utils_1.kdutils.isValid(userID, "number")
            || !utils_1.kdutils.isValid(count, "number")) {
            return null;
        }
        return yield accountMutexFunc(teaID, userID, function () {
            return __awaiter(this, void 0, void 0, function* () {
                let userAccount = yield rpc_1.Rpc.center.callException("kds.dbp.tea.useraccount.get", teaID, userID);
                if (userAccount == null) {
                    return null;
                }
                let v = userAccount.count;
                v += count;
                if (Number.isNaN(v)) {
                    log_1.Log.oth.info("[tea-useraccount] account: v is nan teaID = " + teaID + " userID = " + userID + " count = " + count);
                    return null;
                }
                if (v < 0) {
                    v = 0;
                }
                userAccount.count = v;
                yield rpc_1.Rpc.center.callException("kds.dbp.tea.useraccount.set", teaID, userID, userAccount);
                return userAccount;
            });
        });
    });
}
function valueChanged(h, teaID, userID, valueIdx, count, negEnabled) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!utils_1.kdutils.isValid(teaID, "number")
            || !utils_1.kdutils.isValid(userID, "number")
            || !utils_1.kdutils.isValid(valueIdx, "number")
            || !utils_1.kdutils.isValid(count, "number")) {
            log_1.Log.oth.error("[tea-useraccount] type error", {
                teaID,
                userID,
                valueIdx,
                count,
            });
            return null;
        }
        return yield accountMutexFunc(teaID, userID, function () {
            return __awaiter(this, void 0, void 0, function* () {
                let userAccount = yield rpc_1.Rpc.center.callException("kds.dbp.tea.useraccount.get", teaID, userID);
                if (userAccount == null) {
                    log_1.Log.oth.error("[tea-useraccount] cannot get user account teaID = " + teaID + " userID = " + userID);
                    return null;
                }
                let name = "";
                switch (valueIdx) {
                    case 1:
                        {
                            name = "value1";
                        }
                        break;
                    case 2:
                        {
                            name = "value2";
                        }
                        break;
                    case 3:
                        {
                            name = "value3";
                        }
                        break;
                    default:
                        {
                            name = "value1";
                        }
                        break;
                }
                let v = userAccount[name];
                v += count;
                if (Number.isNaN(v)) {
                    log_1.Log.oth.info("[tea-useraccount] v is nan teaID = " + teaID + " userID = " + userID + " count = " + count);
                    return null;
                }
                if (v < 0) {
                    if (!negEnabled) {
                        log_1.Log.oth.info("[tea-useraccount] v is neg teaID = " + teaID + " userID = " + userID + " count = " + count);
                        return null;
                    }
                }
                userAccount[name] = v;
                yield rpc_1.Rpc.center.callException("kds.dbp.tea.useraccount.set", teaID, userID, userAccount);
                return userAccount;
            });
        });
    });
}
exports.RpcTeaUserAccount = {
    account: accountChanged,
    value: valueChanged,
};
