"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const log_1 = require("../log");
const utils_1 = require("kdweb-core/lib/utils");
const tools_1 = require("../helper/tools");
function cardChange(h, userID, changeCount) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!utils_1.kdutils.isValid(userID, "number") || !utils_1.kdutils.isValid(changeCount, "number")) {
            return false;
        }
        let b = yield tools_1.tools.mutexFunc(userID, function () {
            return __awaiter(this, void 0, void 0, function* () {
                let ret = yield rpc_1.Rpc.center.call("kds.dbp.user.userInfo.get", userID);
                if (ret.code != 0) {
                    return false;
                }
                let userInfo = ret.data;
                if (userInfo == null) {
                    return false;
                }
                let oldCount = userInfo.cardCount;
                userInfo.cardCount += changeCount;
                if (userInfo.cardCount < 0) {
                    //userInfo.cardCount = 0
                    return false;
                }
                if (Number.isNaN(userInfo.cardCount)) {
                    log_1.Log.oth.error("card count change failed changeCount = " + changeCount, userInfo);
                    userInfo.cardCount = oldCount;
                    return false;
                }
                yield rpc_1.Rpc.center.call("kds.dbp.user.userInfo.update", userInfo);
                rpc_1.Rpc.center.call("kds.nt.changed.user.userInfo", userID, userInfo);
                return true;
            });
        });
        return b;
    });
}
function diamondChange(h, userID, changeCount, zeroEnabled) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!utils_1.kdutils.isValid(userID, "number") || !utils_1.kdutils.isValid(changeCount, "number")) {
            return false;
        }
        let b = yield tools_1.tools.mutexFunc(userID, function () {
            return __awaiter(this, void 0, void 0, function* () {
                let ret = yield rpc_1.Rpc.center.call("kds.dbp.user.userInfo.get", userID);
                if (ret.code != 0) {
                    return false;
                }
                let userInfo = ret.data;
                if (userInfo == null) {
                    return false;
                }
                let oldCount = userInfo.diamondCount;
                userInfo.diamondCount += changeCount;
                if (userInfo.diamondCount < 0) {
                    if (zeroEnabled) {
                        userInfo.diamondCount = 0;
                    }
                    else {
                        return false;
                    }
                }
                if (Number.isNaN(userInfo.diamondCount)) {
                    log_1.Log.oth.error("diamond count change failed changeCount = " + changeCount, userInfo);
                    userInfo.diamondCount = oldCount;
                    return false;
                }
                yield rpc_1.Rpc.center.call("kds.dbp.user.userInfo.update", userInfo);
                rpc_1.Rpc.center.call("kds.nt.changed.user.userInfo", userID, userInfo);
                return true;
            });
        });
        return b;
    });
}
function goldChange(h, userID, changeCount, zeroEnabled) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!utils_1.kdutils.isValid(userID, "number") || !utils_1.kdutils.isValid(changeCount, "number")) {
            return false;
        }
        let b = yield tools_1.tools.mutexFunc(userID, function () {
            return __awaiter(this, void 0, void 0, function* () {
                let ret = yield rpc_1.Rpc.center.call("kds.dbp.user.userInfo.get", userID);
                if (ret.code != 0) {
                    return false;
                }
                let userInfo = ret.data;
                if (userInfo == null) {
                    return false;
                }
                let oldCount = userInfo.goldCount;
                userInfo.goldCount += changeCount;
                if (userInfo.goldCount < 0) {
                    if (zeroEnabled) {
                        userInfo.goldCount = 0;
                    }
                    else {
                        return false;
                    }
                }
                if (Number.isNaN(userInfo.goldCount)) {
                    log_1.Log.oth.error("gold count change failed changeCount = " + changeCount, userInfo);
                    userInfo.goldCount = oldCount;
                    return false;
                }
                yield rpc_1.Rpc.center.call("kds.dbp.user.userInfo.update", userInfo);
                rpc_1.Rpc.center.call("kds.nt.changed.user.userInfo", userID, userInfo);
                return true;
            });
        });
        return b;
    });
}
function newUserDefault(h) {
    return __awaiter(this, void 0, void 0, function* () {
        // return {
        // 	card:0,
        // 	gold:5000,
        // 	diamond:0,
        // }
        // 新用户初始金币改为20000
        return {
            card: 0,
            gold: 20000,
            diamond: 0,
        };
    });
}
function cdgChange(h, params) {
    return __awaiter(this, void 0, void 0, function* () {
        log_1.Log.oth.info('cdgChange===>', h, JSON.stringify(params));
        if (!utils_1.kdutils.isValid(params.id, "number")) {
            return false;
        }
        let b = yield tools_1.tools.mutexFunc(params.id, function () {
            return __awaiter(this, void 0, void 0, function* () {
                let ret = yield rpc_1.Rpc.center.call("kds.dbp.user.userInfo.get", params.id);
                if (ret.code != 0) {
                    return false;
                }
                let userInfo = ret.data;
                if (userInfo == null) {
                    return false;
                }
                let gCount = userInfo.goldCount;
                let cCount = userInfo.cardCount;
                let dCount = userInfo.diamondCount;
                userInfo.goldCount += params.goldCount;
                if (userInfo.goldCount < 0) {
                    userInfo.goldCount = 0;
                }
                userInfo.cardCount += params.cardCount;
                if (userInfo.cardCount < 0) {
                    userInfo.cardCount = 0;
                }
                userInfo.diamondCount += params.diamondCount;
                if (userInfo.diamondCount < 0) {
                    userInfo.diamondCount = 0;
                }
                if (Number.isNaN(userInfo.goldCount) || Number.isNaN(userInfo.cardCount) || Number.isNaN(userInfo.diamondCount)) {
                    userInfo.goldCount = gCount;
                    userInfo.cardCount = cCount;
                    userInfo.diamondCount = dCount;
                    return false;
                }
                yield rpc_1.Rpc.center.call("kds.dbp.user.userInfo.update", userInfo);
                rpc_1.Rpc.center.call("kds.nt.changed.user.userInfo", params.id, userInfo);
                yield rpc_1.Rpc.center.call("kds.dbp.user.userInfo.addUpdateLog", params);
                return true;
            });
        });
        return b;
    });
}
exports.RpcUser = {
    card: cardChange,
    diamond: diamondChange,
    gold: goldChange,
    default: newUserDefault,
    cdg: cdgChange,
};
