"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const utils_1 = require("kdweb-core/lib/utils");
const base_1 = require("kdweb-core/lib/service/base");
let dailyTableName = "t_lobby_award_daily";
let sappTableName = "t_lobby_sappshare_daily";
var AwardService;
(function (AwardService) {
    function wxShare(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            //Rpc.center.call("kds.wechat.award.share",userID)
            return {};
        });
    }
    AwardService.wxShare = wxShare;
    function wxAd(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            //Rpc.center.call("kds.wechat.award.advertisement",userID)
            return {};
        });
    }
    AwardService.wxAd = wxAd;
    function daily(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            let userDate = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", dailyTableName, userID.toString());
            if (userDate == date) {
                return base_1.baseService.errJson(1, "今日已经领取过了");
            }
            let count = 10000;
            if (params.ad) {
                count = 20000;
            }
            yield rpc_1.Rpc.center.call("kds.inpay.user.gold", userID, count);
            rpc_1.Rpc.center.callException("kds.dbp.kv.sett", dailyTableName, userID.toString(), date);
            return {
                goldCount: count
            };
        });
    }
    AwardService.daily = daily;
    function free(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let msg = yield rpc_1.Rpc.center.call("kds.dbp.new.gold.getAward", userID);
            if (msg.data.status) {
                let count = 10000;
                yield rpc_1.Rpc.center.call("kds.inpay.user.gold", userID, count);
                return { goldCount: count };
            }
            else {
                return base_1.baseService.errJson(1, "获取视频奖励失败，请重新观看视频");
            }
        });
    }
    AwardService.free = free;
    function setAwardkey(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.call("kds.dbp.new.gold.setAward", userID);
            return { status: true };
        });
    }
    AwardService.setAwardkey = setAwardkey;
    function sappShare(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", sappTableName, userID.toString());
            let t;
            if (str == null) {
                t = {
                    date: date,
                    count: 0,
                };
            }
            else {
                t = JSON.parse(str);
                if (t.date != date) {
                    t.count = 0;
                    t.date = date;
                }
            }
            if (t.count >= 1) {
                return base_1.baseService.errJson(1, "每日最多领取1次哦");
            }
            t.count++;
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", sappTableName, userID.toString(), JSON.stringify(t));
            let count = 5000;
            yield rpc_1.Rpc.center.call("kds.inpay.user.gold", userID, count);
            return {
                goldCount: count
            };
        });
    }
    AwardService.sappShare = sappShare;
    function adFailedShare(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", userID);
            if (userInfo == null) {
                return base_1.baseService.errJson(1, "找不到玩家信息");
            }
            if (userInfo.goldCount >= 20000) {
                return base_1.baseService.errJson(1, "金币数量超过20000，无法领取");
            }
            let count = 5000;
            yield rpc_1.Rpc.center.call("kds.inpay.user.gold", userID, count);
            return {
                goldCount: count
            };
        });
    }
    AwardService.adFailedShare = adFailedShare;
})(AwardService = exports.AwardService || (exports.AwardService = {}));
var AwardTools;
(function (AwardTools) {
    function getDaily(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            let userDate = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", dailyTableName, userID.toString());
            return date != userDate;
        });
    }
    AwardTools.getDaily = getDaily;
})(AwardTools = exports.AwardTools || (exports.AwardTools = {}));
