"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("kdweb-core/lib/service/base");
const rpc_1 = require("../rpc");
const UserErrorCode_1 = require("../../../kds-base-define/src/UserErrorCode");
function AKVerifyService(func) {
    return base_1.lambdaAsyncService.create(function (params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (params.ak == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.AKVerifyError, "登录参数为空");
            }
            let str = yield rpc_1.Rpc.center.callException("kds.access.verify", params.ak);
            if (str == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.AKVerifyError, "登录效验失败");
            }
            let arr = str.split("|");
            let sk = arr[0];
            let userID = Number.parseInt(arr[1]);
            return yield func(sk, userID, params);
        });
    });
}
exports.AKVerifyService = AKVerifyService;
