"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const UserDefine_1 = require("../../../kds-base-define/src/UserDefine");
const rpc_1 = require("../rpc");
const base_1 = require("kdweb-core/lib/service/base");
const UserErrorCode_1 = require("../../../kds-base-define/src/UserErrorCode");
const log_1 = require("../log");
const lobbyTools_1 = require("../tools/lobbyTools");
const config_1 = require("../config");
var LobbyService;
(function (LobbyService) {
    function loginLobby(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", sk);
			log_1.Log.oth.info("[loginLobby] rpc call loginData = ", JSON.stringify(loginData));
            if (loginData == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.GetLoginDataFailed, "获取登录信息失败，请重新登录");
            }
            let ret = {};
            let userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", sk);
			log_1.Log.oth.info("[loginLobby] rpc call userInfo = ", JSON.stringify(userInfo));
            if (userInfo == null) {
                let defaultPurse = yield rpc_1.Rpc.center.callException("kds.inpay.user.default");
                userInfo = {
                    userID: loginData.userID,
                    sk: loginData.sk,
                    nickName: loginData.nickName,
                    sex: loginData.sex,
                    iconUrl: loginData.iconUrl,
                    cardCount: defaultPurse.card || 0,
                    goldCount: defaultPurse.gold || 0,
                    diamondCount: defaultPurse.diamond || 0,
                };
                let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.new", userInfo);
				log_1.Log.oth.info("[loginLobby] rpc call b = ", JSON.stringify(b));
                if (!b) {
                    return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.CreateUserInfoFailed, "创建玩家信息失败");
                }
                ret = {
                    userInfo: userInfo,
                    dailyData: yield lobbyTools_1.LobbyTools.getDailyData(userID),
                    recordData: {
                        groupRecords: []
                    },
                };
            }
            else {
                if (userInfo.nickName != loginData.nickName
                    || userInfo.iconUrl != loginData.iconUrl
                    || userInfo.sex != loginData.sex) {
                    userInfo.nickName = loginData.nickName;
                    userInfo.iconUrl = loginData.iconUrl;
                    userInfo.sex = loginData.sex;
                    yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.update", userInfo);
                }
                let recordData = yield rpc_1.Rpc.center.callException("kds.dbp.user.gamerecord.getAll", loginData.userID);
				log_1.Log.oth.info("[loginLobby] rpc call recordData = ", JSON.stringify(recordData));
                ret = {
                    userInfo: userInfo,
                    dailyData: yield lobbyTools_1.LobbyTools.getDailyData(userID),
                    recordData: recordData,
                    newMail: yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.new.get", userID),
                };
            }
            // let roomID = await Rpc.center.callException("kds.dbp.room.boss",userInfo.userID)
            // let boxCode:string = null
            // if(roomID) {
            // 	let roomPOData:RoomDefine.RoomPOData = await Rpc.center.callException("kds.dbp.room.get",roomID)
            // 	if(roomPOData) {
            // 		boxCode = roomPOData.boxCode
            // 	}
            // }
            let circleMatchID = config_1.Config.localConfig.circleMatchID;
			log_1.Log.oth.info("[loginLobby] rpc call circleMatchID = ", JSON.stringify(circleMatchID));
            if (circleMatchID) {
                let matchData = yield rpc_1.Rpc.center.callException("kds.match.get", circleMatchID);
				log_1.Log.oth.info("[loginLobby] rpc call matchData = ", JSON.stringify(matchData));
                if (matchData == null) {
                    circleMatchID = null;
                }
            }
            ret.circleMatchID = circleMatchID;
            ret.customConfig = yield lobbyTools_1.LobbyTools.getCustomConfig();
            // let realData: RealData = await Rpc.center.callException("kds.dbp.user.real.get",userID);
            // if(realData) {
            // 	let reg = /^(\d{3})\d{4}(\d{4})$/;  
            // 	let phone = realData.phone.replace(reg, "$1****$2");
            // 	ret.nickName = realData.uname + phone;
            // }
            return ret;
        });
    }
    LobbyService.loginLobby = loginLobby;
    /** 新增实名认证写入 */
    function setRealname(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let userInfo = false;
            if (params.userID) {
                userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.real.set", params);
            }
            if (!userInfo) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Lobby_GetUserInfoFailed, "网络不稳定，请稍后再试");
            }
            /** 新增修改用户昵称为 姓名+电话 */
            var reg = /^(\d{3})\d{4}(\d{4})$/;
            let newName = params.name + params.phone.replace(reg, "$1****$2");
            let apiData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", params.userID);
            apiData.nickName = newName;
            yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", apiData);
            return {};
        });
    }
    LobbyService.setRealname = setRealname;
    function delRankAll(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.dbp.rank.delShortAll");
            return {
                code: 0,
                message: "ok",
                type: "success"
            };
        });
    }
    LobbyService.delRankAll = delRankAll;
    LobbyService.RpcLobbyStatus = {
        removeAll: delRankAll,
    };
    /** 新增实名认证获取 */
    function getRealname(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let userInfo = null;
            let dataStatus = false;
            if (userID) {
                userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.real.get", userID);
            }
            if (userInfo) {
                dataStatus = true;
            }
            // if(userInfo == null) {
            // 	return baseService.errJson(UserErrorCode.Lobby_GetUserInfoFailed,"获取玩家信息失败")
            // }
            return {
                dataStatus: dataStatus
            };
        });
    }
    LobbyService.getRealname = getRealname;
    function getUserInfo(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let userInfo = null;
            if (params.userID != null) {
                userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", params.userID);
            }
            else {
                userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", sk);
            }
            if (userInfo == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Lobby_GetUserInfoFailed, "获取玩家信息失败");
            }
            return {
                userInfo: userInfo
            };
        });
    }
    LobbyService.getUserInfo = getUserInfo;
    function getOpenId(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let t = yield rpc_1.Rpc.center.callException("kds.wechat.login", params.gameName, params.code);
                if (t == null) {
                    return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "微信授权失败");
                }
                return { openId: t.openId };
            }
            catch (error) {
                log_1.Log.oth.info("[getOpenId] rpc call exception = ", error);
            }
            return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "微信授权失败");
        });
    }
    LobbyService.getOpenId = getOpenId;
    function bindChannel(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (params.apiID == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "绑定授权失败");
            }
            if (params.accountType == null || params.accountType == UserDefine_1.UserDefine.AccountType.Guest) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "绑定授权失败，类型不正确");
            }
            try {
                let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.getApiID", params.apiID);
                // 已有账号
                if (loginData) {
                    // Log.oth.info("[bindChannel] find exist account apiID = " + params.apiID)
                    // return {
                    // 	success:true,
                    // 	loginData:loginData,
                    // }
                }
                else {
                    loginData = (yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID));
                }
                if (loginData == null) {
                    return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "绑定授权失败");
                }
                if (loginData.accountType != UserDefine_1.UserDefine.AccountType.Guest) {
                    //return baseService.errJson(UserErrorCode.Login_WechatAuth,"非游客账户无法绑定授权")
                }
                log_1.Log.oth.info("[bindChannel] bind account userID = " + userID + " to apiID = " + params.apiID, params);
                loginData.accountType = params.accountType;
                loginData.nickName = params.nickName;
                loginData.iconUrl = params.iconUrl;
                loginData.apiID = params.apiID;
                loginData.sex = params.sex;
                let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", loginData);
                if (b) {
                    yield LobbyService.loginLobby(sk, userID);
                    return {
                        success: true,
                        loginData: UserDefine_1.UserDefine.getUserSideLoginData(loginData),
                    };
                }
            }
            catch (error) {
                log_1.Log.oth.info("[bindChannel] rpc call exception = ", error);
            }
            return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "绑定授权失败");
        });
    }
    LobbyService.bindChannel = bindChannel;
    function bindAdvertisement(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof (params.adCode) != "string") {
                base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Lobby_BindAdFailed, "绑定广告ID失败");
                return;
            }
            yield rpc_1.Rpc.center.callException("kds.dbp.record.ad", userID, params.adCode);
            return { success: true };
        });
    }
    LobbyService.bindAdvertisement = bindAdvertisement;
    function getGroupList(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let groups;
            if (params.gameID) {
                groups = yield rpc_1.Rpc.center.callException("kds.group.getAll", params.gameID);
            }
            else {
                groups = yield rpc_1.Rpc.center.callException("kds.group.getAll");
            }
            if (groups && groups.length > 0) {
                return {
                    groups: groups
                };
            }
            return base_1.baseService.errJson(1, "获取列表失败");
        });
    }
    LobbyService.getGroupList = getGroupList;
    function getGroup(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (params.groupID == null) {
                return {
                    groupData: null
                };
            }
            let groupData = yield rpc_1.Rpc.center.callException("kds.group.get", params.groupID);
            return {
                groupData: groupData,
            };
        });
    }
    LobbyService.getGroup = getGroup;
    function getGroupGameUserCount(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (params.gameID == null) {
                return {
                    userCount: 0
                };
            }
            let userCount = yield rpc_1.Rpc.center.callException("kds.group.getGameUserCount", params.gameID);
            return {
                userCount: userCount ? userCount : 0
            };
        });
    }
    LobbyService.getGroupGameUserCount = getGroupGameUserCount;
    function getGroupUserCount(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (params.groupID == null) {
                return {
                    userCount: 0
                };
            }
            let userCount = yield rpc_1.Rpc.center.callException("kds.group.getUserCount", params.groupID);
            return {
                userCount: userCount ? userCount : 0
            };
        });
    }
    LobbyService.getGroupUserCount = getGroupUserCount;
    function rename(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof (params.nickName) != "string") {
                return base_1.baseService.errJson(1, "昵称错误");
            }
            params.nickName = params.nickName.trim();
            if (!lobbyTools_1.LobbyTools.isValidName(params.nickName)) {
                return base_1.baseService.errJson(1, "昵称长度错误");
            }
            let count = yield lobbyTools_1.LobbyTools.getUserRenameCount(userID);
            if (count >= 2) {
                return base_1.baseService.errJson(1, "修改次数过多，请联系客服");
            }
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID);
            if (loginData == null) {
                return base_1.baseService.errJson(1, "无法找到玩家信息");
            }
            loginData.nickName = params.nickName;
            let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", loginData);
            if (!b) {
                return base_1.baseService.errJson(1, "修改失败，服务器错误");
            }
            count++;
            yield lobbyTools_1.LobbyTools.setUserRenameCount(userID, count);
            rpc_1.Rpc.center.callException("kds.nt.changed.user.loginData", userID, loginData);
            return {};
        });
    }
    LobbyService.rename = rename;
    function changePwd(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof (params.oldPwdMD5) != "string" || typeof (params.newPwdMD5) != "string") {
                return base_1.baseService.errJson(1, "参数错误");
            }
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID);
            if (loginData == null) {
                return base_1.baseService.errJson(1, "无法找到玩家信息");
            }
            if (loginData.pwdMd5 != params.oldPwdMD5) {
                return base_1.baseService.errJson(1, "密码输入错误");
            }
            loginData.pwdMd5 = params.newPwdMD5;
            let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", loginData);
            if (!b) {
                return base_1.baseService.errJson(1, "修改失败，服务器错误");
            }
            rpc_1.Rpc.center.callException("kds.nt.changed.user.loginData", userID, loginData);
            return {};
        });
    }
    LobbyService.changePwd = changePwd;
    function changeIcon(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof (params.iconUrl) != "string") {
                return base_1.baseService.errJson(1, "头像地址错误");
            }
            if (params.iconUrl.length == 0 || params.iconUrl.length >= 512) {
                return base_1.baseService.errJson(1, "头像地址长度错误");
            }
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID);
            if (loginData == null) {
                return base_1.baseService.errJson(1, "无法找到玩家信息");
            }
            loginData.iconUrl = params.iconUrl;
            let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", loginData);
            if (!b) {
                return base_1.baseService.errJson(1, "修改失败，服务器错误");
            }
            rpc_1.Rpc.center.callException("kds.nt.changed.user.loginData", userID, loginData);
            return {};
        });
    }
    LobbyService.changeIcon = changeIcon;
    function msgCheck(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let b = yield rpc_1.Rpc.center.callException("kds.wechat.room.msgCheck", params.gameName, params.content);
            return {
                success: b
            };
        });
    }
    LobbyService.msgCheck = msgCheck;
	function msgCheckNew(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            // let b = yield rpc_1.Rpc.center.callException("kds.wechat.room.msgCheckNew", params.gameName, params.content, params.openid);
            return {
                success: true
            };
        });
    }
    LobbyService.msgCheckNew = msgCheckNew;
})(LobbyService = exports.LobbyService || (exports.LobbyService = {}));
