"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
var MailService;
(function (MailService) {
    function getMails(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let mails = yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.getAll", userID);
            return {
                mails: mails || []
            };
        });
    }
    MailService.getMails = getMails;
    function readMail(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.read", userID, params.mailID);
            return {};
        });
    }
    MailService.readMail = readMail;
    function removeMail(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.delete", userID, params.mailID);
            return {};
        });
    }
    MailService.removeMail = removeMail;
})(MailService = exports.MailService || (exports.MailService = {}));
