"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const KVDefine_1 = require("../../../kds-base-define/src/KVDefine");
const rpc_1 = require("../rpc");
const UserDefine_1 = require("../../../kds-base-define/src/UserDefine");
const award_1 = require("../service/award");
const BaseUtils_1 = require("../../../kds-base-define/src/BaseUtils");
const log_1 = require("../log");
var LobbyTools;
(function (LobbyTools) {
    function getWechatOpenID(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", KVDefine_1.KVDefine.WXUserID2OpenIDTablename, KVDefine_1.KVDefine.WXUserID2OpenIDPrefix + userID);
        });
    }
    LobbyTools.getWechatOpenID = getWechatOpenID;
    function getWechatSSKey(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let openID = yield getWechatOpenID(userID);
            if (openID) {
                return yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", KVDefine_1.KVDefine.WXOpenID2SSKeyTablename, KVDefine_1.KVDefine.WXOpenID2SSKeyPrefix + openID);
            }
            return null;
        });
    }
    LobbyTools.getWechatSSKey = getWechatSSKey;
    function getDailyData(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let t = {
                dailyAward: yield award_1.AwardTools.getDaily(userID)
            };
            return t;
        });
    }
    LobbyTools.getDailyData = getDailyData;
    function isValidName(name) {
        let len = BaseUtils_1.BaseUtils.strlen(name);
        return len >= UserDefine_1.UserDefine.nickNameMinLen && len <= UserDefine_1.UserDefine.nickNameMaxLen;
    }
    LobbyTools.isValidName = isValidName;
    let customConfigKey = "t_lobby_custom_config";
    function getCustomConfig() {
        return __awaiter(this, void 0, void 0, function* () {
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.get", customConfigKey);
            if (str) {
                try {
                    return JSON.parse(str);
                }
                catch (error) {
                    log_1.Log.oth.error("parse custom config failed error = ", error);
                }
            }
            return null;
        });
    }
    LobbyTools.getCustomConfig = getCustomConfig;
    function setCustomConfig(t) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.dbp.kv.set", customConfigKey, JSON.stringify(t));
        });
    }
    LobbyTools.setCustomConfig = setCustomConfig;
    let renameTablename = "t_lobby_rename_count";
    function getUserRenameCount(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", renameTablename, userID.toString());
            if (str) {
                return Number.parseInt(str);
            }
            return 0;
        });
    }
    LobbyTools.getUserRenameCount = getUserRenameCount;
    function setUserRenameCount(userID, count) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", renameTablename, userID.toString(), count.toString());
        });
    }
    LobbyTools.setUserRenameCount = setUserRenameCount;
})(LobbyTools = exports.LobbyTools || (exports.LobbyTools = {}));
