"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const log_1 = require("../log");
class PeekEntityBase {
    get name() {
        return "[peek]";
    }
    get gameID() {
        return -1;
    }
    get msgName() {
        return "";
    }
    onPeek(data) { }
}
exports.PeekEntityBase = PeekEntityBase;
var PeekController;
(function (PeekController) {
    let peekEntities = [];
    function addEntity(entity) {
        if (!peekEntities.includes(entity)) {
            peekEntities.push(entity);
        }
    }
    PeekController.addEntity = addEntity;
    function onMsg(data) {
        return __awaiter(this, void 0, void 0, function* () {
            for (let entity of peekEntities) {
                if (entity.gameID == data.gameID && entity.msgName == data.msgName) {
                    log_1.Log.oth.info("[peek-ctrl] route peek to entity name = " + entity.name);
                    entity.onPeek(data);
                }
                else {
                    log_1.Log.oth.info("[peek-ctrl] ignore gameID = " + entity.gameID + " | msgName = " + entity.msgName);
                }
            }
        });
    }
    PeekController.onMsg = onMsg;
})(PeekController = exports.PeekController || (exports.PeekController = {}));
