"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const log_1 = require("../log");
const store_1 = require("../service/store");
const lobbyTools_1 = require("../tools/lobbyTools");
function getCustomConfig(h) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield lobbyTools_1.LobbyTools.getCustomConfig();
    });
}
function setCustomConfig(h, t) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield lobbyTools_1.LobbyTools.setCustomConfig(t);
    });
}
function addItem(h, t) {
    return __awaiter(this, void 0, void 0, function* () {
        log_1.Log.oth.log("[lobby.ts] addItem" + t);
        return yield store_1.StoreService.callCharge(t);
    });
}
exports.RpcLobby = {
    getCustomConfig,
    setCustomConfig,
    addItem,
};
