"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("kdweb-core/lib/service/base");
const rpc_1 = require("../rpc");
var BagService;
(function (BagService) {
    function getBags(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let reg = yield rpc_1.Rpc.center.callException('kds.dbp.user.bag.get', userID);
            if (!reg) {
                return {
                    goods: []
                };
            }
            let filteredItems = reg.goods.filter(item => item.type === params.type);
            return {
                goods: filteredItems
            };
        });
    }
    BagService.getBags = getBags;
    function useProp(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let reg = yield rpc_1.Rpc.center.callException('kds.dbp.user.bag.get', userID);
            let item = reg.goods.find((msg) => msg.goodsID == params.goodsID);
            if (!item) {
                return base_1.baseService.errJson(1, "参数错误，请重试");
            }
            if (item.count < 1) {
                return base_1.baseService.errJson(1, "道具数量不足");
            }
            item.isUse = true;
            return {
                status: true
            };
        });
    }
    BagService.useProp = useProp;
})(BagService = exports.BagService || (exports.BagService = {}));
