"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const base_1 = require("kdweb-core/lib/service/base");
const utils_1 = require("kdweb-core/lib/utils");
const UserErrorCode_1 = require("../../../kds-base-define/src/UserErrorCode");
var BillService;
(function (BillService) {
    function getBill(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let time = params.startTimestamp || utils_1.kdutils.getMillionSecond();
            let days = params.days || 1;
            if (days < 0) {
                days = 1;
            }
            let bills = yield rpc_1.Rpc.center.callException("kds.bill.user.get", userID, time, days);
            if (bills == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLobby, "获取账单信息失败");
            }
            return {
                bills: bills
            };
        });
    }
    BillService.getBill = getBill;
    function getBillById(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!params.hasOwnProperty('userID') || !params.hasOwnProperty('groupID')) {
                return base_1.baseService.errJson(1, "数据异常");
            }
            let recordData = yield rpc_1.Rpc.center.callException("kds.dbp.user.gamerecord.get", params.userID, params.groupID);
            if (recordData) {
                return { winCount: recordData.win };
            }
            return { winCount: 0 };
        });
    }
    BillService.getBillById = getBillById;
    function getFupan(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield rpc_1.Rpc.center.callException("kds.bill.fupan.get", params.fupanID);
            if (data == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLobby, "获取复盘数据失败");
            }
            return { data: data };
        });
    }
    BillService.getFupan = getFupan;
    function getRoomBills(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let bills = yield rpc_1.Rpc.center.callException("kds.bill.room.get", params.roomID);
            if (bills == null || bills.length == 0) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLobby, "账单数据为空");
            }
            let firstBill = bills[0];
            for (let bill of bills) {
                delete bill.roomPOData;
                delete bill.startDate;
                delete bill.endDate;
                if (bill == firstBill) {
                    continue;
                }
                for (let userInfo of bill.users) {
                    if (firstBill.users.find(v => v.userID == userInfo.userID)) {
                        continue;
                    }
                    firstBill.users.push(userInfo);
                }
                delete bill.users;
            }
            for (let userInfo of firstBill.users) {
                delete userInfo.sk;
            }
            return { bills: bills };
        });
    }
    BillService.getRoomBills = getRoomBills;
})(BillService = exports.BillService || (exports.BillService = {}));
var BillCursorService;
(function (BillCursorService) {
    function getBill(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data;
            if (params.timestamp) {
                data = yield rpc_1.Rpc.center.callException("kds.bill.cursor.user.get", userID, params.cursor, params.timestamp);
            }
            else {
                data = yield rpc_1.Rpc.center.callException("kds.bill.cursor.user.get", userID, params.cursor);
            }
            if (data == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLobby, "获取账单信息失败");
            }
            return {
                data: data
            };
        });
    }
    BillCursorService.getBill = getBill;
    function getTeaBill(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data;
            if (params.timestamp) {
                data = yield rpc_1.Rpc.center.callException("kds.bill.cursor.tea.get", params.teaID, params.cursor, params.timestamp);
            }
            else {
                data = yield rpc_1.Rpc.center.callException("kds.bill.cursor.tea.get", params.teaID, params.cursor);
            }
            if (data == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLobby, "获取账单信息失败");
            }
            return {
                data: data
            };
        });
    }
    BillCursorService.getTeaBill = getTeaBill;
    function getTeaUserBill(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data;
            let targetUserID = params.userID || userID;
            if (params.timestamp) {
                data = yield rpc_1.Rpc.center.callException("kds.bill.cursor.tea.getUser", params.teaID, targetUserID, params.cursor, params.timestamp);
            }
            else {
                data = yield rpc_1.Rpc.center.callException("kds.bill.cursor.tea.getUser", params.teaID, targetUserID, params.cursor);
            }
            if (data == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLobby, "获取账单信息失败");
            }
            return {
                data: data
            };
        });
    }
    BillCursorService.getTeaUserBill = getTeaUserBill;
})(BillCursorService = exports.BillCursorService || (exports.BillCursorService = {}));
