"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const log_1 = require("../log");
const rpc_1 = require("../rpc");
var ChannelService;
(function (ChannelService) {
    function getData(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            /** 指定渠道充值总和 */
            let rechargeCountList = [];
            let rechargeCount = 0;
            /** 指定渠道用户总和 */
            let userCountList = [];
            let userCount = 0;
            let Qsql = '';
            log_1.Log.oth.info("[mysql] getData push userID =>", userID);
            {
                Qsql = "SELECT SUM(amount) AS total_amount FROM t_recharge_records WHERE cid = " + userID;
                rechargeCountList = yield rpc_1.Rpc.center.callException('kds.dbp.channel.execute', Qsql);
            }
            {
                Qsql = "SELECT COUNT(*) AS total_count FROM t_user_bind WHERE cid = " + userID;
                userCountList = yield rpc_1.Rpc.center.callException('kds.dbp.channel.execute', Qsql);
            }
            if (userCountList && userCountList.length > 0) {
                userCount = userCountList[0].total_count == null ? 0 : userCountList[0].total_count;
            }
            if (rechargeCountList && rechargeCountList.length > 0) {
                rechargeCount = rechargeCountList[0].total_amount == null ? 0 : rechargeCountList[0].total_amount;
            }
            log_1.Log.oth.info("[mysql] getData call userCount =>", userCount);
            return {
                rechargeCount: rechargeCount,
                userCount: userCount
            };
        });
    }
    ChannelService.getData = getData;
    function getUserList(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let userList = [];
            let data = yield getChannelUser(params.limit, params.page, userID);
            if (data) {
                userList = data;
            }
            // let ulist = await getChannelUser(params.limit, params.offset, userID)
            // let rlist = await getRecharge(userID)
            // // 遍历第一个对象数组
            // ulist.forEach(item => {
            //     item['amount'] = 0
            //     for(let idx = 0; idx < rlist.length; idx++) {
            //         if(rlist[idx].uid === item.uid) {
            //             item['amount'] += rlist[idx].amount;
            //         }
            //     }
            // });
            // if(ulist) {
            //     userList = ulist
            // }
            return {
                userList: userList
            };
        });
    }
    ChannelService.getUserList = getUserList;
    function getChannelUser(limit, page, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let offset = page * limit;
            let Qsql = 'SELECT a.uid,SUM(COALESCE(b.amount, 0)) AS total_amount,a.cid,a.create_time FROM t_user_bind a LEFT JOIN t_recharge_records b ON a.uid = b.uid WHERE a.cid = ' + userID + ' GROUP BY a.uid ' + ' LIMIT ' + limit + ' OFFSET ' + offset;
            // let Qsql = 'SELECT * FROM t_user_bind WHERE cid = ' + userID
            let userList = yield rpc_1.Rpc.center.callException('kds.dbp.channel.execute', Qsql);
            log_1.Log.oth.info("[mysql] getChannelUser call userList =>", userList);
            return userList;
        });
    }
    function getRecharge(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let Qsql = 'SELECT * FROM t_recharge_records WHERE cid = ' + userID;
            let rechargeList = yield rpc_1.Rpc.center.callException('kds.dbp.channel.execute', Qsql);
            log_1.Log.oth.info("[mysql] getRecharge call rechargeList =>", rechargeList);
            return rechargeList;
        });
    }
})(ChannelService = exports.ChannelService || (exports.ChannelService = {}));
