"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const UserDefine_1 = require("../../../kds-base-define/src/UserDefine");
const rpc_1 = require("../rpc");
const base_1 = require("kdweb-core/lib/service/base");
const UserErrorCode_1 = require("../../../kds-base-define/src/UserErrorCode");
const log_1 = require("../log");
const lobbyTools_1 = require("../tools/lobbyTools");
const config_1 = require("../config");
const utils_1 = require("kdweb-core/lib/utils");
const work_1 = require("./work");
const WorkDefine_1 = require("../../../kds-base-define/src/WorkDefine");
const item_1 = require("./item");
const store_1 = require("./store");
const zlib_1 = require("zlib");
var LobbyService;
(function (LobbyService) {
    function loginLobby(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            //默认为打滚子
            let gameID = 1;
            if (params && typeof (params) == 'object') {
                if (params.hasOwnProperty('toward')) {
                    let time = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss");
                    let userToward = yield rpc_1.Rpc.center.callException("kds.dbp.user.toward.getUserId", userID);
                    if (!userToward) {
                        yield rpc_1.Rpc.center.callException("kds.dbp.user.toward.set", {
                            updateTime: time,
                            timestamp: utils_1.kdutils.getMillionSecond(),
                            toward: params.toward,
                            userID: userID
                        });
                    }
                    else {
                        userToward.toward = params.toward;
                        userToward.updateTime = time;
                        userToward.timestamp = utils_1.kdutils.getMillionSecond();
                        yield rpc_1.Rpc.center.callException("kds.dbp.user.toward.update", userToward);
                    }
                }
                if (params.hasOwnProperty('gameID')) {
                    gameID = params.gameID;
                }
            }
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", sk);
            if (loginData == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.GetLoginDataFailed, "获取登录信息失败，请重新登录");
            }
            let ret = {};
            let userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", sk);
            if (userInfo == null) {
                let defaultPurse = yield rpc_1.Rpc.center.callException("kds.inpay.user.default");
                if (loginData.iconUrl) {
                    loginData.iconUrl = operWechatIcon(loginData.iconUrl);
                }
                userInfo = {
                    userID: loginData.userID,
                    sk: loginData.sk,
                    nickName: loginData.nickName,
                    sex: loginData.sex,
                    iconUrl: loginData.iconUrl,
                    cardCount: defaultPurse.card || 0,
                    goldCount: defaultPurse.gold || 0,
                    diamondCount: defaultPurse.diamond || 0,
                };
                let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.new", userInfo);
                if (!b) {
                    return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.CreateUserInfoFailed, "创建玩家信息失败");
                }
                ret = {
                    userInfo: userInfo,
                    dailyData: yield lobbyTools_1.LobbyTools.getDailyData(userID),
                    recordData: {
                        groupRecords: []
                    },
                };
            }
            else {
                // if (userInfo.nickName != loginData.nickName
                // 	|| userInfo.iconUrl != loginData.iconUrl
                // 	|| userInfo.sex != loginData.sex) {
                // 	userInfo.nickName = loginData.nickName
                // 	userInfo.iconUrl = loginData.iconUrl
                // 	userInfo.sex = loginData.sex
                // 	await Rpc.center.callException("kds.dbp.user.userInfo.update", userInfo)
                // }
                let recordData = yield rpc_1.Rpc.center.callException("kds.dbp.user.gamerecord.getAll", loginData.userID);
                if (userInfo.iconUrl) {
                    userInfo.iconUrl = operWechatIcon(userInfo.iconUrl);
                }
                ret = {
                    userInfo: userInfo,
                    dailyData: yield lobbyTools_1.LobbyTools.getDailyData(userID),
                    recordData: recordData,
                    newMail: yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.new.get", userID, gameID),
                };
            }
            // let roomID = await Rpc.center.callException("kds.dbp.room.boss",userInfo.userID)
            // let boxCode:string = null
            // if(roomID) {
            // 	let roomPOData:RoomDefine.RoomPOData = await Rpc.center.callException("kds.dbp.room.get",roomID)
            // 	if(roomPOData) {
            // 		boxCode = roomPOData.boxCode
            // 	}
            // }
            //任务登录
            yield work_1.WorkService.completeWork(WorkDefine_1.WorkDefine.WorkType.Login, userInfo.userID, gameID);
            let qudao = false;
            try {
                let Qsql = 'SELECT * FROM t_channels WHERE cid = ' + userInfo.userID;
                let channelData = yield rpc_1.Rpc.center.callException('kds.dbp.channel.execute', Qsql);
                log_1.Log.oth.info("[mysql] t_channels get call =>", channelData);
                if (channelData && channelData.length > 0 && channelData[0].status == 0) {
                    qudao = true;
                }
            }
            catch (error) {
                log_1.Log.oth.error("[lobbyLogin] execute t_channels error =>", error);
            }
            let circleMatchID = config_1.Config.localConfig.circleMatchID;
            if (circleMatchID) {
                let matchData = yield rpc_1.Rpc.center.callException("kds.match.get", circleMatchID);
                if (matchData == null) {
                    circleMatchID = null;
                }
            }
            ret.circleMatchID = circleMatchID;
            ret.customConfig = yield lobbyTools_1.LobbyTools.getCustomConfig();
            ret.isChannel = qudao;
            ret.works = {
                collect: yield work_1.WorkService.getCollect(userInfo.userID, gameID),
                desktop: yield work_1.WorkService.getAddDesktop(userInfo.userID, gameID),
            };
            ret.items = yield getItemsOrInit(userInfo.userID);
            ret.taskConfig = {
                data: yield lobbyTools_1.LobbyTools.getTaskConfig(),
                serverTime: utils_1.kdutils.getMillionSecond()
            };
            // ret.test = await Rpc.center.callException('kds.bill.fupan.get',102336)
            // base64Str 是之前 gzip 并转为 Base64 的字符串
            const base64Str = yield rpc_1.Rpc.center.callException('kds.bill.fupan.get', 102336); // 替换为你的 Base64 编码字符串
            // 1. 将 Base64 字符串解码为原始 gzip 数据
            const gzipBuffer = Buffer.from(base64Str, 'base64');
            ret.test = zlib_1.gunzipSync(gzipBuffer);
            return ret;
        });
    }
    LobbyService.loginLobby = loginLobby;
    function getItemsOrInit(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let res = (yield item_1.ItemService.getItems(userID, {})).items;
            if (res.length < 1) {
                return [{ itemID: store_1.ItemID.ticket, count: 0, extData: null }];
            }
            return res;
        });
    }
    LobbyService.getItemsOrInit = getItemsOrInit;
    /** 新增实名认证写入 */
    function setRealname(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let userInfo = false;
            if (params.userID) {
                userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.real.set", params);
            }
            if (!userInfo) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Lobby_GetUserInfoFailed, "网络不稳定，请稍后再试");
            }
            /** 新增修改用户昵称为 姓名+电话 */
            var reg = /^(\d{3})\d{4}(\d{4})$/;
            let newName = params.name + params.phone.replace(reg, "$1****$2");
            let apiData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", params.userID);
            apiData.nickName = newName;
            yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", apiData);
            return {};
        });
    }
    LobbyService.setRealname = setRealname;
    function delRankAll(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.dbp.rank.delShortAll");
            return {
                code: 0,
                message: "ok",
                type: "success"
            };
        });
    }
    LobbyService.delRankAll = delRankAll;
    LobbyService.RpcLobbyStatus = {
        removeAll: delRankAll,
    };
    /** 新增实名认证获取 */
    function getRealname(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let userInfo = null;
            let dataStatus = false;
            if (userID) {
                userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.real.get", userID);
            }
            if (userInfo) {
                dataStatus = true;
            }
            // if(userInfo == null) {
            // 	return baseService.errJson(UserErrorCode.Lobby_GetUserInfoFailed,"获取玩家信息失败")
            // }
            return {
                dataStatus: dataStatus
            };
        });
    }
    LobbyService.getRealname = getRealname;
    function getUserInfo(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let userInfo = null;
            if (params.userID != null) {
                userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", params.userID);
            }
            else {
                userInfo = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", sk);
            }
            if (userInfo == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Lobby_GetUserInfoFailed, "获取玩家信息失败");
            }
            return {
                userInfo: userInfo
            };
        });
    }
    LobbyService.getUserInfo = getUserInfo;
    function getOpenId(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let t = yield rpc_1.Rpc.center.callException("kds.wechat.login", params.gameName, params.code);
                if (t == null) {
                    return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "微信授权失败");
                }
                return { openId: t.openId };
            }
            catch (error) {
                log_1.Log.oth.info("[getOpenId] rpc call exception = ", error);
            }
            return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "微信授权失败");
        });
    }
    LobbyService.getOpenId = getOpenId;
    let wechatIconPrefix = "https://thirdwx.qlogo.cn";
    let wechatIconService = "https://service.pkgame.com/wechat/img";
    function operWechatIcon(url) {
        if (url == "NULL") {
            return url;
        }
        if (url == null) {
            return "NULL";
        }
        // if (url.indexOf(wechatIconPrefix) >= 0 && url.indexOf("?a=a.jpg") == -1) {
        // // 	url = url.replace("https://thirdwx.qlogo.cn", "https://service.pkgame.com/wechat/img")
        // 	url += "?a=a.jpg"
        // }
        if (url.indexOf(wechatIconService) >= 0) {
            url = url.replace("https://service.pkgame.com/wechat/img", "https://thirdwx.qlogo.cn");
        }
        if (url.indexOf("?a=a.jpg") == -1) {
            url += "?a=a.jpg";
        }
        return url;
    }
    function bindChannel(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[bindChannel] 入参 =>", JSON.stringify(params));
            if (params.apiID == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "绑定授权失败");
            }
            if (params.accountType == null || params.accountType == UserDefine_1.UserDefine.AccountType.Guest) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "绑定授权失败，类型不正确");
            }
            if (params.iconUrl) {
                params.iconUrl = operWechatIcon(params.iconUrl);
            }
            try {
                let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.getApiID", params.apiID);
                // 已有账号
                if (loginData) {
                    // Log.oth.info("[bindChannel] find exist account apiID = " + params.apiID)
                    // return {
                    // 	success:true,
                    // 	loginData:loginData,
                    // }
                }
                else {
                    loginData = (yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID));
                }
                if (params.nickName != loginData.nickName) {
                    let data = {
                        gameName: "WM-GZ",
                        content: params.nickName,
                        apiID: loginData.apiID,
                    };
                    let b = yield rpc_1.Rpc.center.callException("kds.wechat.room.msgCheckNew", data.gameName, data.content, data.apiID);
                    if (b) {
                        loginData.nickName = params.nickName;
                    }
                }
                if (loginData == null) {
                    return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "绑定授权失败");
                }
                if (loginData.accountType != UserDefine_1.UserDefine.AccountType.Guest) {
                    //return baseService.errJson(UserErrorCode.Login_WechatAuth,"非游客账户无法绑定授权")
                }
                log_1.Log.oth.info("[bindChannel] bind account userID = " + userID + " to apiID = " + params.apiID, params);
                loginData.accountType = params.accountType;
                // loginData.nickName = params.nickName
                // loginData.iconUrl = params.iconUrl
                loginData.apiID = params.apiID;
                loginData.sex = params.sex;
                let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", loginData);
                let lobbyData = yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.get", loginData.userID);
                lobbyData.nickName = loginData.nickName;
                yield rpc_1.Rpc.center.callException("kds.dbp.user.userInfo.update", lobbyData);
                if (loginData.iconUrl != params.iconUrl && params.iconUrl != "NULL") {
                    let data = {
                        gameName: "WM-GZ",
                        content: params.iconUrl,
                        openid: loginData.apiID,
                        media_type: 2,
                        apiID: loginData.apiID
                    };
                    rpc_1.Rpc.center.callException("kds.wechat.room.mediaCheck", data.gameName, data.content, data.openid, data.media_type, data.apiID);
                }
                if (b) {
                    yield LobbyService.loginLobby(sk, userID);
                    return {
                        success: true,
                        loginData: UserDefine_1.UserDefine.getUserSideLoginData(loginData),
                    };
                }
            }
            catch (error) {
                log_1.Log.oth.info("[bindChannel] rpc call exception = ", error);
            }
            return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WechatAuth, "绑定授权失败");
        });
    }
    LobbyService.bindChannel = bindChannel;
    function bindAdvertisement(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof (params.adCode) != "string") {
                base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Lobby_BindAdFailed, "绑定广告ID失败");
                return;
            }
            yield rpc_1.Rpc.center.callException("kds.dbp.record.ad", userID, params.adCode);
            return { success: true };
        });
    }
    LobbyService.bindAdvertisement = bindAdvertisement;
    function getGroupList(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let groups;
            if (params.gameID) {
                groups = yield rpc_1.Rpc.center.callException("kds.group.getAll", params.gameID);
            }
            else {
                groups = yield rpc_1.Rpc.center.callException("kds.group.getAll");
            }
            if (groups && groups.length > 0) {
                return {
                    groups: groups
                };
            }
            return base_1.baseService.errJson(1, "获取列表失败");
        });
    }
    LobbyService.getGroupList = getGroupList;
    function getGroup(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (params.groupID == null) {
                return {
                    groupData: null
                };
            }
            let groupData = yield rpc_1.Rpc.center.callException("kds.group.get", params.groupID);
            return {
                groupData: groupData,
            };
        });
    }
    LobbyService.getGroup = getGroup;
    function getGroupGameUserCount(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (params.gameID == null) {
                return {
                    userCount: 0
                };
            }
            let userCount = yield rpc_1.Rpc.center.callException("kds.group.getGameUserCount", params.gameID);
            return {
                userCount: userCount ? userCount : 0
            };
        });
    }
    LobbyService.getGroupGameUserCount = getGroupGameUserCount;
    function getGroupUserCount(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (params.groupID == null) {
                return {
                    userCount: 0
                };
            }
            let userCount = yield rpc_1.Rpc.center.callException("kds.group.getUserCount", params.groupID);
            return {
                userCount: userCount ? userCount : 0
            };
        });
    }
    LobbyService.getGroupUserCount = getGroupUserCount;
    function rename(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof (params.nickName) != "string") {
                return base_1.baseService.errJson(1, "昵称错误");
            }
            params.nickName = params.nickName.trim();
            if (!lobbyTools_1.LobbyTools.isValidName(params.nickName)) {
                return base_1.baseService.errJson(1, "昵称长度错误");
            }
            let count = yield lobbyTools_1.LobbyTools.getUserRenameCount(userID);
            if (count >= 2) {
                return base_1.baseService.errJson(1, "修改次数过多，请联系客服");
            }
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID);
            if (loginData == null) {
                return base_1.baseService.errJson(1, "无法找到玩家信息");
            }
            loginData.nickName = params.nickName;
            let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", loginData);
            if (!b) {
                return base_1.baseService.errJson(1, "修改失败，服务器错误");
            }
            count++;
            yield lobbyTools_1.LobbyTools.setUserRenameCount(userID, count);
            rpc_1.Rpc.center.callException("kds.nt.changed.user.loginData", userID, loginData);
            return {};
        });
    }
    LobbyService.rename = rename;
    function changePwd(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof (params.oldPwdMD5) != "string" || typeof (params.newPwdMD5) != "string") {
                return base_1.baseService.errJson(1, "参数错误");
            }
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID);
            if (loginData == null) {
                return base_1.baseService.errJson(1, "无法找到玩家信息");
            }
            if (loginData.pwdMd5 != params.oldPwdMD5) {
                return base_1.baseService.errJson(1, "密码输入错误");
            }
            loginData.pwdMd5 = params.newPwdMD5;
            let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", loginData);
            if (!b) {
                return base_1.baseService.errJson(1, "修改失败，服务器错误");
            }
            rpc_1.Rpc.center.callException("kds.nt.changed.user.loginData", userID, loginData);
            return {};
        });
    }
    LobbyService.changePwd = changePwd;
    function changeIcon(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof (params.iconUrl) != "string") {
                return base_1.baseService.errJson(1, "头像地址错误");
            }
            if (params.iconUrl.length == 0 || params.iconUrl.length >= 512) {
                return base_1.baseService.errJson(1, "头像地址长度错误");
            }
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID);
            if (loginData == null) {
                return base_1.baseService.errJson(1, "无法找到玩家信息");
            }
            loginData.iconUrl = params.iconUrl;
            let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", loginData);
            if (!b) {
                return base_1.baseService.errJson(1, "修改失败，服务器错误");
            }
            rpc_1.Rpc.center.callException("kds.nt.changed.user.loginData", userID, loginData);
            return {};
        });
    }
    LobbyService.changeIcon = changeIcon;
    function msgCheck(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let b = yield rpc_1.Rpc.center.call("kds.wechat.room.msgCheck", params.gameName, params.content);
            if (b.code != 0) {
                return false;
            }
            return {
                success: b
            };
        });
    }
    LobbyService.msgCheck = msgCheck;
    function msgCheckNew(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[msgCheckNew] params =>", JSON.stringify(params));
            let userData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID);
            log_1.Log.oth.info("[msgCheckNew] kds.dbp.user.login.get callback =>" + userData);
            let b = yield rpc_1.Rpc.center.call("kds.wechat.check.msgCheckNew", params.gameName, params.content, userData.apiID);
            log_1.Log.oth.info("[msgCheckNew] kds.wechat.check.msgCheckNew callback =>" + b);
            if (b.code != 0) {
                return false;
            }
            return {
                success: b.data
            };
        });
    }
    LobbyService.msgCheckNew = msgCheckNew;
    function mediaCheck(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let b = yield rpc_1.Rpc.center.call("kds.wechat.check.mediaCheck", params.gameName, params.content, params.openid, params.media_type, params.userid);
            if (b.code != 0) {
                return false;
            }
            return {
                success: b
            };
        });
    }
    LobbyService.mediaCheck = mediaCheck;
})(LobbyService = exports.LobbyService || (exports.LobbyService = {}));
