"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const base_1 = require("kdweb-core/lib/service/base");
const MailDefine_1 = require("../../../kds-base-define/src/MailDefine");
const rpc_1 = require("../rpc");
const log_1 = require("../log");
const lobbyTools_1 = require("../tools/lobbyTools");
var MailService;
(function (MailService) {
    function getMails(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let mails = yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.getAll", userID);
            return {
                mails: mails || []
            };
        });
    }
    MailService.getMails = getMails;
    function readMail(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.read", params.mailID);
            updateNewMail(userID);
            return {};
        });
    }
    MailService.readMail = readMail;
    function removeMail(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.delete", params.mailID);
            if (!ret) {
                return base_1.baseService.errJson(1, "信息异常，请重试");
            }
            let back = yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.getAll", userID);
            if (!back || back.length < 1) {
                yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.new.remove", userID);
            }
            return true;
        });
    }
    MailService.removeMail = removeMail;
    function removeAllMail(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.deleteAll", userID);
            if (!ret) {
                return base_1.baseService.errJson(1, "没有可删除的邮件");
            }
            yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.new.remove", userID);
            return true;
        });
    }
    MailService.removeAllMail = removeAllMail;
    function receiveMail(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let mails = yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.getAll", userID);
            let data;
            if (params.isAll) {
                /** 领全部 */
                let filteredArr = mails.filter(item => !item.attaStatus);
                if (filteredArr.length < 1)
                    return base_1.baseService.errJson(1, "没有可领取的邮件");
                data = yield getAward(filteredArr, userID, sk);
            }
            else {
                /** 领单个 */
                // let mail:MailDefine.MailData = await Rpc.center.callException("kds.dbp.user.mail.get",params.mailID);
                let mail = mails.find((msg) => msg.mailID == params.mailID);
                if (!mail) {
                    return base_1.baseService.errJson(1, "领取失败，邮件信息错误");
                }
                if (mail.attaStatus) {
                    return base_1.baseService.errJson(1, "已领取过奖励");
                }
                data = yield getAward([mail], userID, sk);
            }
            yield updateNewMail(userID);
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            yield lobbyTools_1.LobbyTools.updateItems(userID);
            return true;
        });
    }
    MailService.receiveMail = receiveMail;
    function getAward(mailList, userID, sk) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = {
                money: [],
                prop: []
            };
            let attaList = [];
            for (let i = 0; i < mailList.length; i++) {
                for (let a = 0; a < mailList[i].attaData.length; a++) {
                    let attaData = mailList[i].attaData[a];
                    switch (attaData.attaType) {
                        case MailDefine_1.MailDefine.AttaType.Money:
                            data.money.push({ moneyID: attaData.attaID, count: attaData.attaNumber });
                            break;
                        case MailDefine_1.MailDefine.AttaType.Porp:
                            data.prop.push({ propID: attaData.attaID, count: attaData.attaNumber });
                            attaList.push(attaData);
                            break;
                        default:
                            break;
                    }
                }
                mailList[i].attaStatus = true;
                mailList[i].read = true;
                yield lobbyTools_1.LobbyTools.addItem(userID, data.money);
                log_1.Log.oth.info('[getAward] attaList', attaList);
                yield rpc_1.Rpc.center.callException("kds.inpay.prop.mailAdd", userID, sk, attaList);
                yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.update", mailList[i].mailID, mailList[i]);
            }
            return data;
        });
    }
    function updateNewMail(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.getRead", userID);
            if (ret) {
                yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.new.update", userID, true);
                yield rpc_1.Rpc.center.callException("kds.nt.changed.user.newMail", userID, true);
            }
            else {
                yield rpc_1.Rpc.center.callException("kds.dbp.user.mail.new.update", userID, false);
                yield rpc_1.Rpc.center.callException("kds.nt.changed.user.newMail", userID, false);
            }
        });
    }
})(MailService = exports.MailService || (exports.MailService = {}));
