"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const base_1 = require("kdweb-core/lib/service/base");
const UserErrorCode_1 = require("../../../kds-base-define/src/UserErrorCode");
const utils_1 = require("kdweb-core/lib/utils");
const log_1 = require("../log");
const MutexDefine_1 = require("../../../kds-base-define/src/MutexDefine");
const WechatDefine_1 = require("../../../kds-base-define/src/WechatDefine");
const lobbyTools_1 = require("../tools/lobbyTools");
var StoreService;
(function (StoreService) {
    function getGoods(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!params.hasOwnProperty("tab")) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.CreateUserInfoFailed, "参数错误");
            }
            if (params.tab == 1) {
                return {
                    data: []
                };
            }
            let storeData = yield rpc_1.Rpc.center.callException("kds.dbp.store.getAllByRedis", params.tab);
            if (params.tab == 2) {
                storeData = storeData.filter(item => item.idx < 15 || item.idx > 20);
            }
            return {
                data: storeData || []
            };
        });
    }
    StoreService.getGoods = getGoods;
    function buy(userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            // let config = CSVConfig.store.find(v=>v.idx == params.idx)
            let config = yield rpc_1.Rpc.center.callException("kds.dbp.store.getGoodsByIdx", params.idx);
            if (config == null) {
                return base_1.baseService.errJson(1, "找不到商品");
            }
            if (!utils_1.kdutils.isValid(params.idx, "number")) {
                return base_1.baseService.errJson(1, "商品类型不正确");
            }
            let data = yield getData(userID);
            let saved = false;
            let today = getDailyDate();
            let ret = null;
            do {
                let status = data.status.rewards.find(v => v.idx == params.idx);
                if (status == null) {
                    status = {
                        idx: params.idx,
                        count: 0,
                    };
                    data.status.rewards.push(status);
                    let record = data.record.rewardDates.find(v => v.idx == params.idx);
                    if (record == null) {
                        record = {
                            idx: params.idx,
                            date: today
                        };
                        data.record.rewardDates.push(record);
                    }
                    record.date = today;
                    saved = true;
                }
                // if (config.type == StoreItemType.Ad || config.tab == StoreItemType.Share) {
                if (config.type == StoreItemType.Ad) {
                    // 次数检查
                    if (config.costCount > 0) {
                        if (status.count >= config.costCount) {
                            ret = base_1.baseService.errJson(1, "今日的次数已经达到最大");
                            break;
                        }
                    }
                }
                if (config.type == StoreItemType.Ad) {
                    if (!params.ad) {
                        ret = base_1.baseService.errJson(1, "需要看过视频才能领取哦");
                        break;
                    }
                }
                let back;
                let r = {
                    count: 0,
                    moneyID: config.moneyID
                };
                switch (config.type) {
                    case StoreItemType.Share:
                    case StoreItemType.Ad: {
                        status.count++;
                        saved = true;
                        r.count = config.costCount;
                        back = yield lobbyTools_1.LobbyTools.addItem(userID, [r]);
                        issueItem(userID, back);
                        break;
                    }
                    case StoreItemType.Exchange: {
                        if (config.tab < 2) {
                            let b = yield lobbyTools_1.LobbyTools.useItem(userID, config.costItemID, config.costCount);
                            if (!b) {
                                ret = base_1.baseService.errJson(1, "兑换失败");
                                break;
                            }
                            status.count++;
                            saved = true;
                            r.count = config.mapCount;
                            back = yield lobbyTools_1.LobbyTools.addItem(userID, [r]);
                            issueItem(userID, back);
                        }
                        else if (config.tab == 2) {
                            let b = yield lobbyTools_1.LobbyTools.useItem(userID, config.costItemID, config.costCount);
                            if (!b) {
                                ret = base_1.baseService.errJson(1, "兑换失败");
                                break;
                            }
                            let data = {
                                money: [],
                                prop: [{ propID: config.moneyID, count: config.count }]
                            };
                            yield rpc_1.Rpc.center.callException("kds.inpay.prop.awardAdd", userID, null, data.prop);
                            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
                        }
                        break;
                    }
                    case StoreItemType.Charge: {
                        let cost = config.costCount;
                    }
                }
            } while (false);
            if (saved) {
                _setStore(userID, data);
            }
            if (ret) {
                return ret;
            }
            return {
                status: data.status
            };
        });
    }
    StoreService.buy = buy;
    function waitStore(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            // while(true) {
            // 	let wait = mutex.get(userID)
            // 	if(wait) {
            // 		Log.oth.info("[daily-service] wait for mutex userID = " + userID)
            // 		await wait.promise
            // 		if(wait.isTimeout) {
            // 			Log.oth.error("[daily-service] mutex timeout userID = " + userID)
            // 		}
            // 	} else {
            // 		break 
            // 	}
            // }
            // let wait = new kdasync.waitTimeout(10000)
            // mutex.set(userID,wait)
            // return wait 
            //let b:boolean = 
            yield rpc_1.Rpc.center.callException("kds.mutex.get", MutexDefine_1.MutexDefine.LobbyStore(userID), 10000);
        });
    }
    StoreService.waitStore = waitStore;
    function endStore(userID) {
        // let curWait = mutex.get(userID)
        // if(curWait == wait) {
        // 	mutex.delete(userID)
        // 	wait.resolve()
        // } else {
        // 	Log.oth.error("[daily-service] prev wait invalid userID = " + userID + " timeout = " + wait.isTimeout)
        // }
        rpc_1.Rpc.center.callException("kds.mutex.release", MutexDefine_1.MutexDefine.LobbyStore(userID));
    }
    StoreService.endStore = endStore;
    function getData(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield _getStore(userID);
            let saved = false;
            let today = getDailyDate();
            for (let record of data.record.rewardDates) {
                if (record.date != today) {
                    let status = data.status.rewards.find(v => v.idx == record.idx);
                    if (status) {
                        status.count = 0;
                        saved = true;
                    }
                }
            }
            if (saved) {
                yield _setStore(userID, data);
            }
            return data;
        });
    }
    function _getStore(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = yield getkv(statusKey(userID), true);
            if (data == null) {
                data = {
                    status: getDefaultStatus(),
                    record: {
                        rewardDates: [],
                    }
                };
                yield _setStore(userID, data);
            }
            return data;
        });
    }
    StoreService.kvTablename = "t_lobby_wmgz_kv";
    function _setStore(userID, data) {
        return __awaiter(this, void 0, void 0, function* () {
            yield setkv(statusKey(userID), data, true);
        });
    }
    function statusKey(userID) {
        return "v_store_status_" + userID;
    }
    function getkv(key, json) {
        return __awaiter(this, void 0, void 0, function* () {
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", StoreService.kvTablename, key);
            if (str && json) {
                return JSON.parse(str);
            }
            return str;
        });
    }
    StoreService.getkv = getkv;
    function setkv(key, data, json) {
        return __awaiter(this, void 0, void 0, function* () {
            if (json) {
                data = JSON.stringify(data);
            }
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", StoreService.kvTablename, key, data);
            return true;
        });
    }
    StoreService.setkv = setkv;
    function getDailyDate(time) {
        return utils_1.kdutils.getFmtMoment("YYYY-MM-DD", time);
    }
    StoreService.getDailyDate = getDailyDate;
    let kvSelfRecordTablename = "t_wechat_store_prepare";
    let kvChargeFailedTablename = "t_wechat_store_charge_failed";
    function getSID() {
        return __awaiter(this, void 0, void 0, function* () {
            let sid = yield rpc_1.Rpc.center.callException("kds.ids.getId", "dlgz-store-pay", 20000, 1);
            return sid;
        });
    }
    function buyCharge(userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            params.sandBox = params.sandBox ? true : false;
            // let config = CSVConfig.store.find(v=>v.type == StoreItemType.Charge && v.idx == params.idx)
            let config = yield rpc_1.Rpc.center.callException("kds.dbp.store.getGoodsByIdx", params.idx);
            if (config == null) {
                return base_1.baseService.errJson(1, "没有找到商品");
            }
            let billNo = yield rpc_1.Rpc.center.callException("kds.wechat.pay.getBillNo", params.gameName, userID);
            if (!billNo) {
                return base_1.baseService.errJson(1, "创建订单失败");
            }
            let ret = yield rpc_1.Rpc.center.callException("kds.wechat.pay.prepareSelfPay", params.gameName, userID, config.costCount, billNo, params.sandBox);
            let time = utils_1.kdutils.getMillionSecond();
            let sid = yield getSID();
            let record = {
                idx: params.idx,
                sid: sid,
                userID: userID,
                sandBox: params.sandBox,
                timestamp: time,
                date: utils_1.kdutils.getFmtMoment("YYYY-MM-DD", time),
                fullDate: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time),
                billNo: billNo,
                prepare: ret,
                cash_disbursemen: false,
                moneyID: config.moneyID,
                propType: 1,
            };
            yield rpc_1.Rpc.center.callException("kds.dbp.kv.m.insert", kvSelfRecordTablename, record);
            return {
                sid: sid,
                prepare: ret
            };
        });
    }
    StoreService.buyCharge = buyCharge;
    function chargeDone(userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let config = yield rpc_1.Rpc.center.callException("kds.dbp.store.getGoodsByIdx", params.idx);
            log_1.Log.oth.info('[chargeDone] kds.dbp.store.getGoodsByIdx config callback =>', config);
            if (config == null) {
                return base_1.baseService.errJson(1, "没有找到商品");
            }
            params.sandBox = params.sandBox || false;
            let rets = yield rpc_1.Rpc.center.callException("kds.dbp.kv.m.get", kvSelfRecordTablename, { sid: params.sid });
            log_1.Log.oth.info('[chargeDone] kds.dbp.kv.m.get rets callback =>', rets);
            if (rets == null || rets.length == 0) {
                return base_1.baseService.errJson(1, "没有找到支付订单");
            }
            let record = rets[0];
            // let config = CSVConfig.store.find(v=>v.type == StoreItemType.Charge && v.idx == record.idx)
            // let itemConfig = CSVConfig.items.find(v=>v.itemID == config.itemID)
            let content = config ? "购买" + config.name : " 购买游戏内道具";
            let code = yield rpc_1.Rpc.center.callException("kds.wechat.pay.payMoney", params.gameName, userID, config.costCount, content, params.sandBox, record.billNo);
            log_1.Log.oth.info('[chargeDone] kds.wechat.pay.payMoney callback =>', code);
            if (code != WechatDefine_1.WechatDefine.Pay.PayCode.success) {
                log_1.Log.oth.error("[store] user charge done failed code = " + WechatDefine_1.WechatDefine.Pay.PayCode[code] + " userID = " + userID);
                rpc_1.Rpc.center.callException("kds.dbp.kv.m.insert", kvChargeFailedTablename, record);
                return base_1.baseService.errJson(1, "购买失败，请与客服联系");
            }
            // let time = kdutils.getMillionSecond();
            // let date = kdutils.getFmtMoment("YYYY-MM-DD")
            // await Rpc.center.callException("kds.dbp.recharge.setRchrg",
            // {userID: userID, count: config.costCount, lastDate: date, timestamp: time})
            // let exp = await Rpc.center.callException("kds.dbp.recharge.getExp",userID);
            // if(exp) {
            // 	exp.count += config.costCount
            // 	await Rpc.center.callException("kds.dbp.recharge.updateExp",exp);
            // }
            // if(record.cash_disbursemen) {
            // 	return {}
            // }
            // record.cash_disbursemen = true;
            // await Rpc.center.callException("kds.dbp.kv.m.update",kvSelfRecordTablename,{billNo:record.billNo},record);
            // await addItem(userID,config.count,config.moneyID)
            return true;
        });
    }
    StoreService.chargeDone = chargeDone;
    function issueItem(userID, ret, source = '') {
        return __awaiter(this, void 0, void 0, function* () {
            if (ret.length > 0) {
                let data = {
                    money: ret,
                    prop: []
                };
                rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
                yield lobbyTools_1.LobbyTools.setRechargeRecords({ userID: userID, money: ret, prop: [], source: source });
            }
        });
    }
    function callCharge(billNo) {
        return __awaiter(this, void 0, void 0, function* () {
            log_1.Log.oth.info("[callCharge] billNo =>" + billNo);
            let rets = yield rpc_1.Rpc.center.callException("kds.dbp.kv.m.get", kvSelfRecordTablename, { billNo: billNo });
            log_1.Log.oth.info("[callCharge] kds.dbp.kv.m.get callback rets =>", rets);
            if (rets == null || rets.length == 0) {
                return {};
            }
            let record = rets[0];
            if (record.cash_disbursemen) {
                return {};
            }
            let exp = yield rpc_1.Rpc.center.callException("kds.dbp.recharge.getExp", record.userID);
            log_1.Log.oth.info("[callCharge] kds.dbp.recharge.getExp callback exp =>", exp);
            let config = yield rpc_1.Rpc.center.callException("kds.dbp.store.getGoodsByIdx", record.idx);
            log_1.Log.oth.info("[callCharge] kds.dbp.store.getGoodsByIdx callback config =>", config);
            let time = utils_1.kdutils.getMillionSecond();
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD");
            if (exp) {
                exp.count += config.costCount / 100;
                yield rpc_1.Rpc.center.callException("kds.dbp.recharge.updateExp", exp);
            }
            else {
                yield rpc_1.Rpc.center.callException("kds.dbp.recharge.setExp", { userID: record.userID, count: config.costCount / 100, lastDate: date, timestamp: time });
            }
            let ret;
            let r = {
                count: record.prepare.buyQuantity / 100,
                moneyID: record.moneyID
            };
            switch (record.propType) {
                case 1:
                    // 商城
                    record.cash_disbursemen = true;
                    yield rpc_1.Rpc.center.callException("kds.dbp.kv.m.update", kvSelfRecordTablename, { billNo: billNo }, record);
                    ret = yield lobbyTools_1.LobbyTools.addItem(record.userID, [r]);
                    issueItem(record.userID, ret, '商城');
                    break;
                case 2:
                    // 一元购
                    record.cash_disbursemen = true;
                    yield rpc_1.Rpc.center.callException("kds.dbp.kv.m.update", kvSelfRecordTablename, { billNo: billNo }, record);
                    ret = yield lobbyTools_1.LobbyTools.addItem(record.userID, [r]);
                    issueItem(record.userID, ret, '六元购');
                    break;
                default:
                    break;
            }
            let Qsql = "select * from t_user_bind where uid = " + record.userID;
            let channelData = yield rpc_1.Rpc.center.callException('kds.dbp.channel.execute', Qsql);
            log_1.Log.oth.info('get t_user_bind callback', channelData);
            if (channelData) {
                let Ssql = `INSERT INTO t_recharge_records (orderno, userid, channelid, amount) VALUES ('${billNo}', ${record.userID}, ${channelData.cid}, ${record.prepare.buyQuantity / 100})`;
                log_1.Log.oth.info('sql =>', Ssql);
                yield rpc_1.Rpc.center.callException('kds.dbp.channel.execute', Ssql);
            }
            return {};
        });
    }
    StoreService.callCharge = callCharge;
})(StoreService = exports.StoreService || (exports.StoreService = {}));
function StoreServiceFunction(func) {
    return function (sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = null;
            yield StoreService.waitStore(userID);
            try {
                ret = yield func(userID, params);
            }
            catch (error) {
                log_1.Log.oth.error("[Store-service] error = ", error);
            }
            StoreService.endStore(userID);
            return ret ? ret : base_1.baseService.errJson(1, "商城业务请求失败");
        });
    };
}
exports.StoreServiceFunction = StoreServiceFunction;
function getDefaultStatus() {
    let ret = {
        rewards: [],
    };
    return ret;
}
var StoreItemType;
(function (StoreItemType) {
    StoreItemType[StoreItemType["Exchange"] = 0] = "Exchange";
    StoreItemType[StoreItemType["Charge"] = 1] = "Charge";
    StoreItemType[StoreItemType["Share"] = 2] = "Share";
    StoreItemType[StoreItemType["Ad"] = 3] = "Ad";
})(StoreItemType = exports.StoreItemType || (exports.StoreItemType = {}));
var ItemID;
(function (ItemID) {
    ItemID.gold = 100000;
    ItemID.diamond = 100001;
    ItemID.ticket = 100002;
    ItemID.ex_huafei = 900000;
})(ItemID = exports.ItemID || (exports.ItemID = {}));
