"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const base_1 = require("kdweb-core/lib/service/base");
const utils_1 = require("kdweb-core/lib/utils");
const store_1 = require("./store");
const log_1 = require("../log");
const ItemDefine_1 = require("../../../kds-base-define/src/ItemDefine");
const UserDefine_1 = require("../../../kds-base-define/src/UserDefine");
const lobbyTools_1 = require("../tools/lobbyTools");
let kvSelfRecordTablename = "t_wechat_store_prepare";
let kvChargeFailedTablename = "t_wechat_store_charge_failed";
var TaskService;
(function (TaskService) {
    function getDailyDate(time) {
        return utils_1.kdutils.getFmtMoment("YYYY-MM-DD", time);
    }
    TaskService.getDailyDate = getDailyDate;
    function buy(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let day;
            params.type == 0 ? day = 7 : day = 30;
            // return baseService.errJson(1, "特惠月卡限购活动已结束\n更多精彩活动敬请期待");
            let config = yield rpc_1.Rpc.center.callException("kds.dbp.assets.task.getById", params.taskid);
            if (config == null) {
                return base_1.baseService.errJson(1, "找不到商品");
            }
            let price = params.type == 0 ? config.weekPrice : config.monthPrice;
            let ret = null;
            switch (params.taskid) {
                case UserDefine_1.UserDefine.TaskType.monthlyCards:
                    // let data = await Rpc.center.callException("kds.dbp.task.monthlycard.get", { sk: sk })
                    // if (data && data.buyCount >= 1) {
                    // 	return baseService.errJson(1, "活动期间只能购买1次");
                    // }
                    let data = yield getIsBuyMonthly(sk);
                    if (!data.isBuy) {
                        return base_1.baseService.errJson(1, data.errmsg);
                    }
                default:
                    break;
            }
            let b = yield lobbyTools_1.LobbyTools.useItem(userID, config.moneyID, price);
            if (!b) {
                ret = base_1.baseService.errJson(1, "兑换失败");
            }
            if (ret) {
                return ret;
            }
            yield lobbyTools_1.LobbyTools.updateItems(userID);
            yield setTask(userID, sk, config.taskID, day);
            return yield addMonthlyCardReward(userID, sk, day);
        });
    }
    TaskService.buy = buy;
    function setTask(userID, sk, taskID, time) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield lobbyTools_1.LobbyTools.mutexFunc(userID, function () {
                return __awaiter(this, void 0, void 0, function* () {
                    let b = null;
                    switch (taskID) {
                        case UserDefine_1.UserDefine.TaskType.monthlyCards:
                            log_1.Log.oth.info("[newtest] userID", userID, sk, time);
                            b = yield rpc_1.Rpc.center.callException("kds.inpay.task.monthlyCards", userID, sk, time);
                            break;
                        case UserDefine_1.UserDefine.TaskType.noble:
                            b = yield rpc_1.Rpc.center.callException("kds.inpay.task.noble", userID, sk);
                            break;
                        default:
                            break;
                    }
                    log_1.Log.oth.info("[setTask] callback", b);
                });
            });
        });
    }
    TaskService.setTask = setTask;
    function addMonthlyCardReward(userID, sk, day) {
        return __awaiter(this, void 0, void 0, function* () {
            let time = utils_1.kdutils.getMillionSecond();
            let str = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss");
            log_1.Log.oth.info("[addMonthlyCardReward] 0000");
            let ret = yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.get", { sk: sk });
            if (!ret || time > ret.endTime) {
                return false;
            }
            let data = {
                money: [],
                prop: []
            };
            let count = 30000;
            data.prop = [{ propID: 200000, count: day }, { propID: 200010, count: 5 }, { propID: 200004, count: 10 }, { propID: 200005, count: 10 }, { propID: 200006, count: 10 }, { propID: 200007, count: 10 }, { propID: 200008, count: 10 }, { propID: 200009, count: 10 }];
            if (ret.lastGet != 0 && lobbyTools_1.LobbyTools.isTimestampToday(ret.lastGet)) {
                yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            }
            else {
                // let exp = await Rpc.center.callException("kds.dbp.recharge.getExp", userID);
                // if (exp) {
                // 	if (exp.count >= 900) {
                // 		count += count
                // 	} else if (exp.count >= 150) {
                // 		count += count * 0.5
                // 	}
                // }
                data.money = [{ moneyID: ItemDefine_1.ItemID.gold, count: count }];
                // let r:UserDefine.AddItemData = {
                // 	count:count,
                // 	moneyID: ItemID.gold
                // }
                yield lobbyTools_1.LobbyTools.addItem(userID, data.money);
                yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            }
            lobbyTools_1.LobbyTools.issueItem(userID, data, '滚王令');
            ret.lastGet = time;
            yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.update", ret);
            yield rpc_1.Rpc.center.callException("kds.inpay.prop.awardAdd", userID, sk, data.prop);
            let msg = {
                getRewardTime: time,
                userID: userID,
                sk: sk,
                timeStr: str,
            };
            yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.setLog", msg);
            return true;
        });
    }
    TaskService.addMonthlyCardReward = addMonthlyCardReward;
    function adminGrantMonthlyCard(userID, sk) {
        return __awaiter(this, void 0, void 0, function* () {
            let time = utils_1.kdutils.getMillionSecond();
            let str = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss");
            let ret = yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.get", { sk: sk });
            if (!ret || time > ret.endTime) {
                return false;
            }
            let data = {
                money: [],
                prop: []
            };
            let count = 30000;
            data.prop = [{ propID: 200000, count: 30 }, { propID: 200010, count: 5 },
                { propID: 200004, count: 10 }, { propID: 200005, count: 10 }, { propID: 200006, count: 10 },
                { propID: 200007, count: 10 }, { propID: 200008, count: 10 }, { propID: 200009, count: 10 }
            ];
            if (ret.lastGet != 0 && lobbyTools_1.LobbyTools.isTimestampToday(ret.lastGet)) {
                yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            }
            else {
                // let exp = await Rpc.center.callException("kds.dbp.recharge.getExp", userID);
                // if (exp) {
                // 	if (exp.count >= 900) {
                // 		count += count
                // 	} else if (exp.count >= 150) {
                // 		count += count * 0.5
                // 	}
                // }
                data.money = [{ moneyID: ItemDefine_1.ItemID.gold, count: count }];
                // let r:UserDefine.AddItemData = {
                // 	count:count,
                // 	moneyID: ItemID.gold
                // }
                // let r = {
                // 	money:[{count:count,moneyID: ItemID.gold}],
                // 	prop:[]
                // }
                yield lobbyTools_1.LobbyTools.addItem(userID, data.money);
                yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            }
            lobbyTools_1.LobbyTools.issueItem(userID, data, '滚王令');
            ret.lastGet = time;
            yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.update", ret);
            yield rpc_1.Rpc.center.callException("kds.inpay.prop.awardAdd", userID, sk, data.prop);
            let msg = {
                getRewardTime: time,
                userID: userID,
                sk: sk,
                timeStr: str,
            };
            yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.setLog", msg);
            return true;
        });
    }
    TaskService.adminGrantMonthlyCard = adminGrantMonthlyCard;
    function setMonthlyCardReward(userID, sk) {
        return __awaiter(this, void 0, void 0, function* () {
            let time = utils_1.kdutils.getMillionSecond();
            let str = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss");
            let ret = yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.get", { sk: sk });
            if (!ret || time > ret.endTime || ret.lastGet != 0 && lobbyTools_1.LobbyTools.isTimestampToday(ret.lastGet)) {
                return true;
            }
            ret.lastGet = time;
            yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.update", ret);
            let count = 30000;
            // let exp = await Rpc.center.callException("kds.dbp.recharge.getExp", userID);
            // if (exp) {
            // 	if (exp.count >= 900) {
            // 		count += count
            // 	} else if (exp.count >= 150) {
            // 		count += count * 0.5
            // 	}
            // }
            // let r:UserDefine.AddItemData = {
            // 	count:count,
            // 	moneyID: ItemID.gold
            // }
            let data = {
                money: [{ moneyID: ItemDefine_1.ItemID.gold, count: count }],
                prop: [{ propID: 200010, count: 5 },
                    { propID: 200004, count: 10 }, { propID: 200005, count: 10 }, { propID: 200006, count: 10 },
                    { propID: 200007, count: 10 }, { propID: 200008, count: 10 }, { propID: 200009, count: 10 }
                ]
            };
            yield lobbyTools_1.LobbyTools.addItem(userID, data.money);
            lobbyTools_1.LobbyTools.issueItem(userID, data, '滚王令');
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, data);
            yield rpc_1.Rpc.center.callException("kds.inpay.prop.awardAdd", userID, sk, data.prop);
            let msg = {
                getRewardTime: time,
                userID: userID,
                sk: sk,
                timeStr: str,
            };
            yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.setLog", msg);
            return true;
        });
    }
    TaskService.setMonthlyCardReward = setMonthlyCardReward;
    // 获取贵族页面信息
    function getNoble(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let noble = yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.get", sk, userID);
            let data = null;
            if (!noble) {
                data = {
                    userID: userID,
                    sk: sk,
                    dayPack: 0,
                    weekPack: 0,
                    monthPack: 0,
                    gradePack: [],
                };
                yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.set", data);
            }
            else {
                data = noble;
            }
            let levelData = yield getNobleLevel(userID);
            let callData = {
                dayPack: lobbyTools_1.LobbyTools.isTimestampToday(data.dayPack),
                weekPack: lobbyTools_1.LobbyTools.isThisWeek(data.weekPack),
                monthPack: lobbyTools_1.LobbyTools.isThisMonth(data.monthPack),
                dayActive: false,
                weekActive: false,
                monthActive: false,
                gradeData: {
                    list: [],
                    level: 0
                },
                thisLevel: levelData.thisLevel,
                nextLevel: levelData.nextLevel,
                // jindu: levelData.count,
                nowHaveEx: levelData.nowHaveEx,
                nowNeedEx: levelData.nowNeedEx,
                nextjindu: getLevelExp(levelData.nextLevel),
                dayRewardInfo: { prop: [], money: [{ moneyID: ItemDefine_1.ItemID.gold, count: 5000 }] },
                weekRewardInfo: { prop: [], money: [{ moneyID: ItemDefine_1.ItemID.gold, count: 50000 }] },
                monthRewardInfo: { prop: [], money: [{ moneyID: ItemDefine_1.ItemID.gold, count: 100000 }] },
            };
            for (let a = 0; a < levelData.list.length; a++) {
                let cc = data.gradePack.find((msg) => msg == levelData.list[a]);
                if (cc == undefined) {
                    let back = getNobleInfo(levelData.list[a]);
                    callData.gradeData.list.push({ count: back.count, moneyID: back.moneyID });
                    callData.gradeData.level = back.level;
                    break;
                }
                if (a == levelData.list.length - 1 && callData.gradeData.list.length < 1 && levelData.thisLevel < 8) {
                    let back = getNobleInfo(levelData.nextLevel);
                    callData.gradeData.list.push({ count: back.count, moneyID: back.moneyID });
                    callData.gradeData.level = back.level;
                }
            }
            if (levelData.list.indexOf(3) != -1)
                callData.dayActive = true;
            if (levelData.list.indexOf(5) != -1)
                callData.weekActive = true;
            if (levelData.list.indexOf(7) != -1)
                callData.monthActive = true;
            return callData;
        });
    }
    TaskService.getNoble = getNoble;
    // 领取等级礼包
    function getLevelPack(sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let noble = yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.get", sk, userID);
            let data = null;
            if (!noble) {
                return base_1.baseService.errJson(1, "领取失败");
            }
            else {
                data = noble;
            }
            let levelData = yield getNobleLevel(userID);
            if (levelData.list.length < 1) {
                return base_1.baseService.errJson(1, "领取失败");
            }
            let list = levelData.list.find((msg) => msg == params.level);
            if (list == undefined) {
                return base_1.baseService.errJson(1, "未到礼包等级无法领取");
            }
            let isLingQu = data.gradePack.find((msg) => msg == params.level);
            if (isLingQu != undefined) {
                return base_1.baseService.errJson(1, "已领取过等级奖励");
            }
            data.gradePack.push(params.level);
            let rewardData = getNobleInfo(params.level);
            // let r:UserDefine.AddItemData = {
            // 	count:rewardData.count,
            // 	moneyID: rewardData.moneyID
            // }
            let r = {
                money: [{ count: rewardData.count, moneyID: ItemDefine_1.ItemID.gold }],
                prop: []
            };
            yield lobbyTools_1.LobbyTools.addItem(userID, r.money);
            lobbyTools_1.LobbyTools.issueItem(userID, r, '贵族等级礼包');
            // let msg = {
            // 	money: [{ moneyID: rewardData.moneyID, count: rewardData.count }],
            // 	prop: []
            // }
            yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.update", data);
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, r);
            return { success: true };
        });
    }
    TaskService.getLevelPack = getLevelPack;
    // 领取天礼包
    function getDayNoble(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let noble = yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.get", sk, userID);
            let data = null;
            if (!noble) {
                return base_1.baseService.errJson(1, "领取失败");
            }
            else {
                data = noble;
            }
            let levelData = yield getNobleLevel(userID);
            if (levelData.list.length < 1 || levelData.list.indexOf(3) == -1) {
                return base_1.baseService.errJson(1, "领取失败");
            }
            if (lobbyTools_1.LobbyTools.isTimestampToday(data.dayPack)) {
                return base_1.baseService.errJson(1, "今日已领");
            }
            data.dayPack = utils_1.kdutils.getMillionSecond();
            let logData = {
                userID: userID,
                sk: sk,
                time: utils_1.kdutils.getFmtMoment("YYYY-MM-DD"),
                timestamp: utils_1.kdutils.getMillionSecond(),
                money: [{ moneyID: ItemDefine_1.ItemID.gold, count: 5000 }],
                prop: []
            };
            // let r:UserDefine.AddItemData = {
            // 	count:5000,
            // 	moneyID: ItemID.gold
            // }
            let r = {
                money: [{ count: 5000, moneyID: ItemDefine_1.ItemID.gold }],
                prop: []
            };
            yield lobbyTools_1.LobbyTools.addItem(userID, r.money);
            lobbyTools_1.LobbyTools.issueItem(userID, r, '贵族天礼包');
            // let msg = {
            // 	money: [{ moneyID: ItemID.gold, count: 5000 }],
            // 	prop: []
            // }
            yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.update", data);
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, r);
            yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.setLog", logData);
            return { success: true };
        });
    }
    TaskService.getDayNoble = getDayNoble;
    // 领取周礼包
    function getWeekNoble(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let noble = yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.get", sk, userID);
            let data = null;
            if (!noble) {
                return base_1.baseService.errJson(1, "领取失败");
            }
            else {
                data = noble;
            }
            let levelData = yield getNobleLevel(userID);
            if (levelData.list.length < 1 || levelData.list.indexOf(5) == -1) {
                return base_1.baseService.errJson(1, "领取失败");
            }
            if (lobbyTools_1.LobbyTools.isThisWeek(data.weekPack)) {
                return base_1.baseService.errJson(1, "本周已领");
            }
            data.weekPack = utils_1.kdutils.getMillionSecond();
            let logData = {
                userID: userID,
                sk: sk,
                time: utils_1.kdutils.getFmtMoment("YYYY-MM-DD"),
                timestamp: utils_1.kdutils.getMillionSecond(),
                money: [{ moneyID: ItemDefine_1.ItemID.gold, count: 50000 }],
                prop: []
            };
            // let r:UserDefine.AddItemData = {
            // 	count:50000,
            // 	moneyID: ItemID.gold
            // }
            let r = {
                money: [{ count: 50000, moneyID: ItemDefine_1.ItemID.gold }],
                prop: []
            };
            yield lobbyTools_1.LobbyTools.addItem(userID, r.money);
            lobbyTools_1.LobbyTools.issueItem(userID, r, '贵族周礼包');
            // let msg = {
            // 	money: [{ moneyID: ItemID.gold, count: 50000 }],
            // 	prop: []
            // }
            yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.update", data);
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, r);
            yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.setLog", logData);
            return { success: true };
        });
    }
    TaskService.getWeekNoble = getWeekNoble;
    // 领取月礼包
    function getMonthNoble(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let noble = yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.get", sk, userID);
            let data = null;
            if (!noble) {
                return base_1.baseService.errJson(1, "领取失败");
            }
            else {
                data = noble;
            }
            let levelData = yield getNobleLevel(userID);
            if (levelData.list.length < 1 || levelData.list.indexOf(7) == -1) {
                return base_1.baseService.errJson(1, "领取失败");
            }
            if (lobbyTools_1.LobbyTools.isThisMonth(data.monthPack)) {
                return base_1.baseService.errJson(1, "本月已领");
            }
            data.monthPack = utils_1.kdutils.getMillionSecond();
            let logData = {
                userID: userID,
                sk: sk,
                time: utils_1.kdutils.getFmtMoment("YYYY-MM-DD"),
                timestamp: utils_1.kdutils.getMillionSecond(),
                money: [{ moneyID: ItemDefine_1.ItemID.gold, count: 100000 }],
                prop: []
            };
            // let r:UserDefine.AddItemData = {
            // 	count:100000,
            // 	moneyID: ItemID.gold
            // }
            let r = {
                money: [{ count: 100000, moneyID: ItemDefine_1.ItemID.gold }],
                prop: []
            };
            yield lobbyTools_1.LobbyTools.addItem(userID, r.money);
            lobbyTools_1.LobbyTools.issueItem(userID, r, '贵族月礼包');
            // let msg = {
            // 	money: [{ moneyID: ItemID.gold, count: 100000 }],
            // 	prop: []
            // }
            yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.update", data);
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.award", userID, r);
            yield rpc_1.Rpc.center.callException("kds.dbp.task.noble.setLog", logData);
            return { success: true };
        });
    }
    TaskService.getMonthNoble = getMonthNoble;
    // 获取月卡剩余天数
    function getMonthlyCardTime(sk, userID) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield getIsBuyMonthly(sk);
        });
    }
    TaskService.getMonthlyCardTime = getMonthlyCardTime;
})(TaskService = exports.TaskService || (exports.TaskService = {}));
function getIsBuyMonthly(sk) {
    return __awaiter(this, void 0, void 0, function* () {
        let ret = yield rpc_1.Rpc.center.callException("kds.dbp.task.monthlycard.get", { sk: sk });
        if (ret) {
            let remainder = lobbyTools_1.LobbyTools.getLeaveDate(ret.endTime / 1000);
            let isBuy = remainder < 1 ? true : false;
            let errmsg = "在月卡有效期内不可重复购买";
            if (isBuy) {
                return { time: remainder, count: ret.buyCount, isBuy };
            }
            return { time: remainder, count: ret.buyCount, isBuy, errmsg };
        }
        return { time: 0, count: 0, isBuy: true };
    });
}
function getNobleLevel(userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let data = yield rpc_1.Rpc.center.callException("kds.dbp.recharge.getExp", userID);
        let count = 0;
        let list = [];
        let thisLevel = 0;
        let nextLevel = 1;
        let nowHaveEx = 0;
        let nowNeedEx = 0;
        if (data) {
            count = data.count;
        }
        if (count < 6) {
            thisLevel = 0;
            nextLevel = 1;
            nowHaveEx = count;
            nowNeedEx = 6;
            list.push(0);
        }
        else if (count >= 6 && count < 30) {
            thisLevel = 1;
            nextLevel = 2;
            nowHaveEx = count - 6;
            nowNeedEx = 30 - 6;
            list.push(0, 1);
        }
        else if (count >= 30 && count < 70) {
            thisLevel = 2;
            nextLevel = 3;
            nowHaveEx = count - 30;
            nowNeedEx = 70 - 30;
            list.push(0, 1, 2);
        }
        else if (count >= 70 && count < 150) {
            thisLevel = 3;
            nextLevel = 4;
            nowHaveEx = count - 70;
            nowNeedEx = 150 - 70;
            list.push(0, 1, 2, 3);
        }
        else if (count >= 150 && count < 250) {
            thisLevel = 4;
            nextLevel = 5;
            nowHaveEx = count - 150;
            nowNeedEx = 250 - 150;
            list.push(0, 1, 2, 3, 4);
        }
        else if (count >= 250 && count < 400) {
            thisLevel = 5;
            nextLevel = 6;
            nowHaveEx = count - 250;
            nowNeedEx = 400 - 250;
            list.push(0, 1, 2, 3, 4, 5);
        }
        else if (count >= 400 && count < 600) {
            thisLevel = 6;
            nextLevel = 7;
            nowHaveEx = count - 400;
            nowNeedEx = 600 - 400;
            list.push(0, 1, 2, 3, 4, 5, 6);
        }
        else if (count >= 600 && count < 900) {
            thisLevel = 7;
            nextLevel = 8;
            nowHaveEx = count - 600;
            nowNeedEx = 900 - 600;
            list.push(0, 1, 2, 3, 4, 5, 6, 7);
        }
        else if (count >= 900) {
            thisLevel = 8;
            nextLevel = 8;
            nowHaveEx = count - 900;
            nowNeedEx = 300;
            list.push(0, 1, 2, 3, 4, 5, 6, 7, 8);
        }
        return { list, thisLevel, nextLevel, count: count, nowHaveEx, nowNeedEx };
    });
}
function getNobleInfo(level) {
    switch (level) {
        case 0:
            return { count: 1000, moneyID: ItemDefine_1.ItemID.gold, level: 0 };
        case 1:
            return { count: 2000, moneyID: ItemDefine_1.ItemID.gold, level: 1 };
        case 2:
            return { count: 5000, moneyID: ItemDefine_1.ItemID.gold, level: 2 };
        case 3:
            return { count: 10000, moneyID: ItemDefine_1.ItemID.gold, level: 3 };
        case 4:
            return { count: 20000, moneyID: ItemDefine_1.ItemID.gold, level: 4 };
        case 5:
            return { count: 50000, moneyID: ItemDefine_1.ItemID.gold, level: 5 };
        case 6:
            return { count: 100000, moneyID: ItemDefine_1.ItemID.gold, level: 6 };
        case 7:
            return { count: 200000, moneyID: ItemDefine_1.ItemID.gold, level: 7 };
        case 8:
            return { count: 588888, moneyID: ItemDefine_1.ItemID.gold, level: 8 };
        default:
            break;
    }
}
function getLevelExp(level) {
    switch (level) {
        case 1:
            return 6;
        case 2:
            return 30;
        case 3:
            return 70;
        case 4:
            return 150;
        case 5:
            return 250;
        case 6:
            return 400;
        case 7:
            return 600;
        case 8:
            return 900;
        default:
            return 900;
    }
}
function TaskServiceFunction(func) {
    return function (sk, userID, params) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = null;
            yield store_1.StoreService.waitStore(userID);
            try {
                ret = yield func(sk, userID, params);
            }
            catch (error) {
                log_1.Log.oth.error("[Store-service] error = ", error);
            }
            store_1.StoreService.endStore(userID);
            return ret ? ret : base_1.baseService.errJson(1, "活动业务请求失败");
        });
    };
}
exports.TaskServiceFunction = TaskServiceFunction;
