"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const wcore = require("kdweb-core");
const config_1 = require("./config");
const rpc_1 = require("./rpc");
const lobby_1 = require("./service/lobby");
const room_1 = require("./service/room");
const bill_1 = require("./service/bill");
const common_1 = require("./tools/common");
const award_1 = require("./service/award");
const match_1 = require("./service/match");
const tea_1 = require("./service/tea");
const mail_1 = require("./service/mail");
const compression = require("compression");
const log_1 = require("./log");
const path = require("path");
const store_1 = require("./service/store");
const task_1 = require("./service/task");
const channel_1 = require("./service/channel");
const bag_1 = require("./service/bag");
const work_1 = require("./service/work");
const controller_1 = require("./peek/controller");
const result_gameid_1_1 = require("./peek/result_gameid_1");
const item_1 = require("./service/item");
function lambda(func) {
    return common_1.AKVerifyService(func);
}
let app = new wcore.service.entity(config_1.Config.otherConfig.userPort);
app.app.use(compression());
app.setAllowOrigin();
app.addInstance("/login", lambda(lobby_1.LobbyService.loginLobby));
app.addInstance("/wechat/auth", lambda(lobby_1.LobbyService.getOpenId));
app.addInstance("/channel/bind", lambda(lobby_1.LobbyService.bindChannel));
app.addInstance("/ad/bind", lambda(lobby_1.LobbyService.bindAdvertisement));
app.addInstance("/userInfo", lambda(lobby_1.LobbyService.getUserInfo));
app.addInstance("/dlgz/item/get", lambda(item_1.ItemServiceFunction(item_1.ItemService.getItems)));
app.addInstance("/group/list", lambda(lobby_1.LobbyService.getGroupList));
app.addInstance("/group/get", lambda(lobby_1.LobbyService.getGroup));
app.addInstance("/group/usercount", lambda(lobby_1.LobbyService.getGroupUserCount));
app.addInstance("/group/gameusercount", lambda(lobby_1.LobbyService.getGroupGameUserCount));
app.addInstance("/match/list", lambda(match_1.MatchService.getMatchList));
app.addInstance("/match/config", lambda(match_1.MatchService.getMatchConfig));
app.addInstance("/match/rank", lambda(match_1.MatchService.getRank));
app.addInstance("/match/enter", lambda(match_1.MatchService.enterMatch));
app.addInstance("/match/enterroom", lambda(match_1.MatchService.enterRoom));
app.addInstance("/match/rooms", lambda(match_1.MatchService.userGetRooms));
app.addInstance("/match/selfrecord", lambda(match_1.MatchService.getSelfRecord));
app.addInstance("/match/scorebill", lambda(match_1.MatchService.getScoreBill));
app.addInstance("/match/signup", lambda(match_1.MatchService.userSignUp));
app.addInstance("/match/reward/get", lambda(match_1.MatchService.getRewardData));
app.addInstance("/match/reward/gain", lambda(match_1.MatchService.gainReward));
app.addInstance("/match/admin/signup", lambda(match_1.MatchService.adminSignUp));
app.addInstance("/match/admin/unsignup", lambda(match_1.MatchService.adminUnSignUp));
app.addInstance("/match/admin/userinfo", lambda(match_1.MatchService.adminGetUserInfo));
app.addInstance("/match/admin/alluserinfos", lambda(match_1.MatchService.adminGetAllUserInfo));
app.addInstance("/match/admin/setuserinfo", lambda(match_1.MatchService.adminSetUserInfo));
app.addInstance("/match/admin/realtime", lambda(match_1.MatchService.adminGetRealtime));
app.addInstance("/match/admin/rooms", lambda(match_1.MatchService.adminGetRooms));
app.addInstance("/match/admin/createroom", lambda(match_1.MatchService.adminCreateRoom));
app.addInstance("/match/admin/jiesanroom", lambda(match_1.MatchService.adminJiesanRoom));
/** 清空比赛排行榜 */
app.addInstance("/match/delRankAll", lambda(lobby_1.LobbyService.delRankAll));
app.addInstance("/award/gold/setawardkey", lambda(award_1.AwardService.setAwardkey));
app.addInstance("/info/msgcheck", lambda(lobby_1.LobbyService.msgCheck));
//zhb图片/语音安全2.0
app.addInstance("/info/msgchecknew", lambda(lobby_1.LobbyService.msgCheckNew));
app.addInstance("/info/mediaCheck", lambda(lobby_1.LobbyService.mediaCheck));
/** 获取商品 */
app.addInstance("/store/getGoogs", lambda(store_1.StoreService.getGoods));
app.addInstance("/store/buycharge", lambda(store_1.StoreServiceFunction(store_1.StoreService.buyCharge)));
app.addInstance("/store/buy", lambda(store_1.StoreServiceFunction(store_1.StoreService.buy)));
app.addInstance("/store/chargedone", lambda(store_1.StoreServiceFunction(store_1.StoreService.chargeDone)));
app.addInstance("/task/buy", lambda(task_1.TaskServiceFunction(task_1.TaskService.buy)));
app.addInstance("/task/getNoble", lambda(task_1.TaskService.getNoble));
app.addInstance("/task/getLevelPack", lambda(task_1.TaskService.getLevelPack));
app.addInstance("/task/getDayNoble", lambda(task_1.TaskService.getDayNoble));
app.addInstance("/task/getWeekNoble", lambda(task_1.TaskService.getWeekNoble));
app.addInstance("/task/getMonthNoble", lambda(task_1.TaskService.getMonthNoble));
app.addInstance("/task/getMonthTime", lambda(task_1.TaskService.getMonthlyCardTime));
app.addInstance("/user/free/data", lambda(award_1.AwardService.getRewardCount));
app.addInstance("/task/getReward", lambda(award_1.AwardService.getReward));
app.addInstance("/channel/getData", lambda(channel_1.ChannelService.getData));
app.addInstance("/channel/getUserList", lambda(channel_1.ChannelService.getUserList));
app.addInstance("/match/admin/initcards", lambda(match_1.MatchService.adminInitCards)); //一把牌生成牌
app.addInstance("/room/create", lambda(room_1.RoomService.createRoom));
app.addInstance("/room/wechat/shareid", lambda(room_1.RoomService.getWechatShareID));
app.addInstance("/bill/get", lambda(bill_1.BillService.getBill));
app.addInstance("/bill/other", lambda(bill_1.BillService.getBillById));
app.addInstance("/bill/room", lambda(bill_1.BillService.getRoomBills));
app.addInstance("/fupan/get", lambda(bill_1.BillService.getFupan));
app.addInstance("/cursor/bill/user", lambda(bill_1.BillCursorService.getBill));
app.addInstance("/cursor/bill/tea", lambda(bill_1.BillCursorService.getTeaBill));
app.addInstance("/cursor/bill/teauser", lambda(bill_1.BillCursorService.getTeaUserBill));
app.addInstance("/award/wechatshare", lambda(award_1.AwardService.wxShare));
app.addInstance("/award/wechatad", lambda(award_1.AwardService.wxAd));
app.addInstance("/award/gold/daily", lambda(award_1.AwardService.daily));
app.addInstance("/award/gold/free", lambda(award_1.AwardService.free));
app.addInstance("/award/gold/bkptSubsidy", lambda(award_1.AwardService.bkptSubsidy));
app.addInstance("/award/gold/setawardkey", lambda(award_1.AwardService.setAwardkey));
// 签到
app.addInstance("/award/chackin/get", lambda(award_1.AwardService.getChackinData));
app.addInstance("/award/chackin/set", lambda(award_1.AwardService.chackin));
app.addInstance("/award/chackin/reset", lambda(award_1.AwardService.reChackin));
app.addInstance("/award/chackin/accumulate", lambda(award_1.AwardService.accumulate));
// 任务
app.addInstance("/award/work/get", lambda(work_1.WorkService.getWorkList));
app.addInstance("/award/work/reward", lambda(work_1.WorkService.reward));
app.addInstance("/award/work/collectGame", lambda(work_1.WorkService.collectGame));
app.addInstance("/award/work/addDesktop", lambda(work_1.WorkService.addDesktop));
// 记牌器接口
app.addInstance("/award/cardrec/get", lambda(award_1.AwardService.getCardRecorderCount));
app.addInstance("/award/cardrec/set", lambda(award_1.AwardService.receiveCardRecorder));
app.addInstance("/award/gold/sappshare", lambda(award_1.AwardService.sappShare));
app.addInstance("/award/gold/adfailedshare", lambda(award_1.AwardService.adFailedShare));
// 获取邮件列表
app.addInstance("/mail/list", lambda(mail_1.MailService.getMails));
// 领取邮件奖励
app.addInstance("/mail/receive", lambda(mail_1.MailService.receiveMail));
// 更改邮件状态为已读
app.addInstance("/mail/read", lambda(mail_1.MailService.readMail));
// 删除指定mailID的邮件
app.addInstance("/mail/remove", lambda(mail_1.MailService.removeMail));
// 删除用户所有邮件 后端逻辑不考虑附件是否领取
app.addInstance("/mail/removeAll", lambda(mail_1.MailService.removeAllMail));
// 获取用户背包信息
app.addInstance("/bag/get", lambda(bag_1.BagService.getBags));
app.addInstance("/room/tea/create", lambda(room_1.RoomService.createTeaRoom));
app.addInstance("/info/rename", lambda(lobby_1.LobbyService.rename));
app.addInstance("/info/changepwd", lambda(lobby_1.LobbyService.changePwd));
app.addInstance("/info/changeicon", lambda(lobby_1.LobbyService.changeIcon));
app.addInstance("/tea/user/enter", lambda(tea_1.TeaService.enter));
app.addInstance("/tea/user/list", lambda(tea_1.TeaService.getList));
app.addInstance("/tea/user/jiesanroom", lambda(tea_1.TeaService.jiesanRoom));
app.addInstance("/tea/user/createroom", lambda(tea_1.TeaService.createRoom));
app.addInstance("/tea/user/getdata", lambda(tea_1.TeaService.getTeaFullData));
app.addInstance("/tea/user/getsimpledata", lambda(tea_1.TeaService.getTeaSimpleData));
app.addInstance("/tea/user/rooms", lambda(tea_1.TeaService.getTeaRooms));
app.addInstance("/tea/user/create", lambda(tea_1.TeaService.createTea));
app.addInstance("/tea/user/charge", lambda(tea_1.TeaService.charge));
app.addInstance("/tea/user/get/data", lambda(tea_1.TeaService.getTeaData));
app.addInstance("/tea/user/get/member", lambda(tea_1.TeaService.getTeaMember));
app.addInstance("/tea/user/get/simplemember", lambda(tea_1.TeaService.getSimpleTeaMember));
app.addInstance("/tea/user/get/template", lambda(tea_1.TeaService.getTeaTemplate));
app.addInstance("/tea/user/get/account", lambda(tea_1.TeaService.getTeaAccount));
app.addInstance("/tea/user/get/auth", lambda(tea_1.TeaService.getTeaAuth));
app.addInstance("/tea/template/add", lambda(tea_1.TeaService.addTemplate));
app.addInstance("/tea/template/rename", lambda(tea_1.TeaService.renameTemplate));
app.addInstance("/tea/template/update", lambda(tea_1.TeaService.updateTemplate));
app.addInstance("/tea/template/remove", lambda(tea_1.TeaService.removeTemplate));
app.addInstance("/tea/template/create", lambda(tea_1.TeaService.createRoomByTemplate));
app.addInstance("/tea/admin/add", lambda(tea_1.TeaService.addAdmin));
app.addInstance("/tea/admin/remove", lambda(tea_1.TeaService.removeAdmin));
app.addInstance("/tea/admin/auth", lambda(tea_1.TeaService.updateAuth));
app.addInstance("/tea/member/req", lambda(tea_1.TeaService.memberReq));
app.addInstance("/tea/member/refuse", lambda(tea_1.TeaService.memberRefuse));
app.addInstance("/tea/member/agree", lambda(tea_1.TeaService.memberAgree));
app.addInstance("/tea/member/remove", lambda(tea_1.TeaService.memberRemove));
app.addInstance("/tea/member/invite", lambda(tea_1.TeaService.memberInvite));
app.addInstance("/tea/member/invite/search", lambda(tea_1.TeaService.memberInviteSearch));
app.addInstance("/tea/member/invite/refuse", lambda(tea_1.TeaService.memberInviteRefuse));
app.addInstance("/tea/member/invite/agree", lambda(tea_1.TeaService.memberInviteAgree));
app.addInstance("/tea/member/invite/remove", lambda(tea_1.TeaService.memberInviteRemove));
app.addInstance("/tea/account/count", lambda(tea_1.TeaService.accountCount));
app.addInstance("/tea/account/value", lambda(tea_1.TeaService.accountValue));
app.addInstance("/tea/proxy/settype", lambda(tea_1.TeaService.setProxyType));
app.addInstance("/tea/proxy/setcost", lambda(tea_1.TeaService.setDeskCost));
app.addInstance("/tea/proxy/getcost", lambda(tea_1.TeaService.getDeskCost));
app.addInstance("/tea/record/user", lambda(tea_1.TeaService.getUserValueRecord));
app.addInstance("/tea/record/tea", lambda(tea_1.TeaService.getTeaValueRecord));
app.addInstance("/tea/daily/user", lambda(tea_1.TeaService.getTeaUserBill));
app.addInstance("/tea/daily/fund", lambda(tea_1.TeaService.getTeaFundBill));
app.addInstance("/tea/daily/funduser", lambda(tea_1.TeaService.getTeaFundUserBill));
controller_1.PeekController.addEntity(new result_gameid_1_1.WorkPeek_Result_GameID1);
app.listen();
rpc_1.Rpc.init();
let localConfig = config_1.Config.localConfig;
if (localConfig.extName) {
    try {
        let projDirname = path.resolve();
        let filePath = path.join(projDirname, "..", localConfig.extName, "lib", localConfig.extName, "src", "start.js");
        console.log("path = " + filePath);
        let ext = require(filePath);
        ext.init({
            app: app,
            rpc: rpc_1.Rpc.center
        });
    }
    catch (error) {
        log_1.Log.oth.error("error to load ext name = " + localConfig.extName, error);
    }
}
