"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const KVDefine_1 = require("../../../kds-base-define/src/KVDefine");
const rpc_1 = require("../rpc");
const UserDefine_1 = require("../../../kds-base-define/src/UserDefine");
const award_1 = require("../service/award");
const BaseUtils_1 = require("../../../kds-base-define/src/BaseUtils");
const log_1 = require("../log");
const utils_1 = require("kdweb-core/lib/utils");
const MutexDefine_1 = require("../../../kds-base-define/src/MutexDefine");
const ItemDefine_1 = require("../../../kds-base-define/src/ItemDefine");
var LobbyTools;
(function (LobbyTools) {
    function getWechatOpenID(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", KVDefine_1.KVDefine.WXUserID2OpenIDTablename, KVDefine_1.KVDefine.WXUserID2OpenIDPrefix + userID);
        });
    }
    LobbyTools.getWechatOpenID = getWechatOpenID;
    function getWechatSSKey(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let openID = yield getWechatOpenID(userID);
            if (openID) {
                return yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", KVDefine_1.KVDefine.WXOpenID2SSKeyTablename, KVDefine_1.KVDefine.WXOpenID2SSKeyPrefix + openID);
            }
            return null;
        });
    }
    LobbyTools.getWechatSSKey = getWechatSSKey;
    function getDailyData(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let t = {
                dailyAward: yield award_1.AwardTools.getDaily(userID)
            };
            return t;
        });
    }
    LobbyTools.getDailyData = getDailyData;
    function isValidName(name) {
        let len = BaseUtils_1.BaseUtils.strlen(name);
        return len >= UserDefine_1.UserDefine.nickNameMinLen && len <= UserDefine_1.UserDefine.nickNameMaxLen;
    }
    LobbyTools.isValidName = isValidName;
    let customConfigKey = "t_lobby_custom_config";
    function getCustomConfig() {
        return __awaiter(this, void 0, void 0, function* () {
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.get", customConfigKey);
            if (str) {
                try {
                    return JSON.parse(str);
                }
                catch (error) {
                    log_1.Log.oth.error("parse custom config failed error = ", error);
                }
            }
            return null;
        });
    }
    LobbyTools.getCustomConfig = getCustomConfig;
    function getTaskConfig() {
        return __awaiter(this, void 0, void 0, function* () {
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.assets.task.getAll");
            if (str) {
                return str;
            }
            return [];
        });
    }
    LobbyTools.getTaskConfig = getTaskConfig;
    function setCustomConfig(t) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.dbp.kv.set", customConfigKey, JSON.stringify(t));
        });
    }
    LobbyTools.setCustomConfig = setCustomConfig;
    function setRechargeRecords(t) {
        return __awaiter(this, void 0, void 0, function* () {
            let time = utils_1.kdutils.getMillionSecond();
            let date = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss");
            yield rpc_1.Rpc.center.callException("kds.dbp.recharge.setRchrg", { userID: t.userID, money: t.money, prop: t.prop, createDate: date, timestamp: time, source: t.source });
        });
    }
    LobbyTools.setRechargeRecords = setRechargeRecords;
    let renameTablename = "t_lobby_rename_count";
    function getUserRenameCount(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", renameTablename, userID.toString());
            if (str) {
                return Number.parseInt(str);
            }
            return 0;
        });
    }
    LobbyTools.getUserRenameCount = getUserRenameCount;
    function setUserRenameCount(userID, count) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.dbp.kv.sett", renameTablename, userID.toString(), count.toString());
        });
    }
    LobbyTools.setUserRenameCount = setUserRenameCount;
    // 当前天
    function isTimestampToday(timestamp) {
        // 创建当前时间的 Date 对象
        const currentDate = new Date();
        // 将时间戳转换为 Date 对象
        const dateFromTimestamp = new Date(timestamp);
        // 判断年、月、日是否相同
        const isSameYear = currentDate.getFullYear() === dateFromTimestamp.getFullYear();
        const isSameMonth = currentDate.getMonth() === dateFromTimestamp.getMonth();
        const isSameDay = currentDate.getDate() === dateFromTimestamp.getDate();
        // 如果年、月、日都相同，则是今天
        return isSameYear && isSameMonth && isSameDay;
    }
    LobbyTools.isTimestampToday = isTimestampToday;
    // 当前月
    function isThisMonth(timestamp) {
        const now = new Date();
        const year = now.getFullYear();
        const month = now.getMonth();
        const targetDate = new Date(timestamp);
        const targetYear = targetDate.getFullYear();
        const targetMonth = targetDate.getMonth();
        return year === targetYear && month === targetMonth;
    }
    LobbyTools.isThisMonth = isThisMonth;
    //当前周
    function isThisWeek(timestamp) {
        const now = new Date();
        const weekStart = new Date(now.getFullYear(), now.getMonth(), now.getDate() - now.getDay() + 1); // 周一
        const weekEnd = new Date(now.getFullYear(), now.getMonth(), now.getDate() + (7 - now.getDay())); // 周日
        const targetDate = new Date(timestamp);
        return targetDate >= weekStart && targetDate <= weekEnd;
    }
    LobbyTools.isThisWeek = isThisWeek;
    //剩余几天
    function getLeaveDate(targetTimestamp) {
        // 获取当前时间戳
        let currentTimestamp = Math.floor(Date.now() / 1000);
        // 计算剩余时间戳
        let remainingTimestamp = targetTimestamp - currentTimestamp;
        // 如果剩余时间戳为负数，则返回 0
        if (remainingTimestamp <= 0) {
            return 0;
        }
        // 将剩余时间戳转换为剩余天数（假设一天为 86400 秒）
        let remainingDays = Math.ceil(remainingTimestamp / 86400);
        return remainingDays;
    }
    LobbyTools.getLeaveDate = getLeaveDate;
    //今天周几
    function getWeekNumber() {
        const daysOfWeek = [7, 1, 2, 3, 4, 5, 6];
        const dayOfWeek = (new Date()).getDay();
        return daysOfWeek[dayOfWeek];
    }
    LobbyTools.getWeekNumber = getWeekNumber;
    /**
     * 传入毫秒时间戳判断距当前几天，当天返回0
     * @param timestamp 过去时间戳(毫秒)
     * @returns
     */
    function daysFromNow(timestamp) {
        const now = new Date();
        const previous = new Date(timestamp);
        // 获取当前日期的年份、月份和日期
        const nowYear = now.getFullYear();
        const nowMonth = now.getMonth();
        const nowDate = now.getDate();
        // 获取时间戳对应日期的年份、月份和日期
        const previousYear = previous.getFullYear();
        const previousMonth = previous.getMonth();
        const previousDate = previous.getDate();
        // 计算日期差异，使得早于时间戳的日期返回负数，晚于时间戳的日期返回正数
        const differenceInDays = (new Date(previousYear, previousMonth, previousDate).getTime() - new Date(nowYear, nowMonth, nowDate).getTime()) / (24 * 60 * 60 * 1000);
        return differenceInDays;
    }
    LobbyTools.daysFromNow = daysFromNow;
    function addItem(userID, list) {
        return __awaiter(this, void 0, void 0, function* () {
            let ret = yield _addItem(userID, list);
            if (!ret) {
                return [];
            }
            log_1.Log.oth.info('store.ts addItem');
            return ret;
        });
    }
    LobbyTools.addItem = addItem;
    /** 获取本周23:59:59 毫秒时间戳*/
    function getEndOfWeekTimestamp() {
        // 获取当前日期
        let now = new Date();
        // 计算本周的星期天（周日）的日期
        let dayOfWeek = now.getDay(); // 获取今天是本周的第几天（0 - 6）
        let diffToSunday = 7 - dayOfWeek; // 计算距离下一个星期天的天数
        // 设置时间为本周日的23:59:59
        let endOfWeek = new Date(now.getFullYear(), now.getMonth(), now.getDate() + diffToSunday, 23, 59, 59, 999);
        // 获取毫秒时间戳
        let timestamp = endOfWeek.getTime();
        return timestamp;
    }
    LobbyTools.getEndOfWeekTimestamp = getEndOfWeekTimestamp;
    function mutexFunc(userID, func) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                let b = yield rpc_1.Rpc.center.callException("kds.mutex.get", ItemMutexKey(userID), 10000);
                if (!b) {
                    log_1.Log.oth.info("get mutex failed userID = " + userID);
                    return false;
                }
                let ret = yield func();
                return ret;
            }
            catch (error) {
                log_1.Log.oth.error("get mutex failed userID = " + userID + " error = ", error);
            }
            finally {
                yield rpc_1.Rpc.center.call("kds.mutex.release", ItemMutexKey(userID));
            }
            return false;
        });
    }
    LobbyTools.mutexFunc = mutexFunc;
    function getRandomCount(count, per) {
        let max = Math.floor(count * (1 + per / 100));
        let step = max - count;
        step = utils_1.kdutils.intRandom(0, step);
        return count + step;
    }
    LobbyTools.getRandomCount = getRandomCount;
    function _addItem(userID, items) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield mutexFunc(userID, function () {
                return __awaiter(this, void 0, void 0, function* () {
                    let datas = [];
                    for (let item of items) {
                        // let itemConfig = CSVConfig.items.find(v=>v.itemID == item.itemID)
                        let itemConfig = item;
                        // let config = await Rpc.center.callException("kds.dbp.store.getGoodsByIdx",params.idx)
                        if (itemConfig == null) {
                            log_1.Log.oth.error("[item-tools] store cannot get item id = " + item.moneyID + " userID = " + userID);
                            continue;
                        }
                        let addItemID = -1;
                        let addCount = 0;
                        // if(itemConfig.map) {
                        // 	addItemID = itemConfig.map.itemID
                        // 	addCount = itemConfig.map.count
                        // } else {
                        addItemID = item.moneyID;
                        addCount = item.count;
                        // }
                        addCount = addCount || 1;
                        if (item.per) {
                            addCount = getRandomCount(addCount, item.per);
                        }
                        let b = false;
                        switch (addItemID) {
                            case ItemDefine_1.ItemID.gold:
                                {
                                    b = yield rpc_1.Rpc.center.callException("kds.inpay.user.gold", userID, addCount);
                                }
                                break;
                            case ItemDefine_1.ItemID.diamond:
                                {
                                    b = yield rpc_1.Rpc.center.callException("kds.inpay.user.diamond", userID, addCount);
                                }
                                break;
                            default:
                                {
                                    let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID);
                                    b = yield rpc_1.Rpc.center.callException("kds.dbp.item.add", userID, addItemID, addCount, loginData.unionID);
                                }
                                break;
                        }
                        log_1.Log.oth.info("[item-tools] store give item to userID = " + userID
                            + " addItemID = " + addItemID
                            + " count = " + item.count
                            + " addCount = " + addCount
                            + " per = " + item.per
                            + " b = " + b);
                        if (!b) {
                            log_1.Log.oth.error("[item-tools] store add item failed userID = " + userID + " itemID = " + addItemID);
                        }
                        else {
                            datas.push({
                                moneyID: addItemID,
                                count: addCount,
                            });
                        }
                    }
                    return datas;
                });
            });
        });
    }
    function ItemMutexKey(userID) {
        //return "DLMJItem|UserID=" + userID
        return MutexDefine_1.MutexDefine.LobbyItem(userID);
    }
    function issueItem(userID, ret, source = '') {
        return __awaiter(this, void 0, void 0, function* () {
            yield setRechargeRecords({ userID: userID, money: ret.money, prop: ret.prop, source: source });
        });
    }
    LobbyTools.issueItem = issueItem;
    function useItem(userID, itemID, itemCount) {
        return __awaiter(this, void 0, void 0, function* () {
            itemCount = itemCount || 0;
            if (itemCount == 0) {
                return false;
            }
            itemID = itemID || 0;
            return yield LobbyTools.mutexFunc(userID, function () {
                return __awaiter(this, void 0, void 0, function* () {
                    let b = false;
                    switch (itemID) {
                        case ItemDefine_1.ItemID.gold:
                            {
                                b = yield rpc_1.Rpc.center.callException("kds.inpay.user.gold", userID, -itemCount);
                            }
                            break;
                        case ItemDefine_1.ItemID.diamond:
                            {
                                b = yield rpc_1.Rpc.center.callException("kds.inpay.user.diamond", userID, -itemCount);
                            }
                            break;
                        default:
                            {
                                b = yield rpc_1.Rpc.center.callException("kds.dbp.item.use", userID, itemID, itemCount);
                            }
                            break;
                    }
                    log_1.Log.oth.info("[item-tools] store use item from userID = " + userID + " itemID = " + itemID + " count = " + itemCount + " b = " + b);
                    if (!b) {
                        log_1.Log.oth.error("[item-tools] store use item failed userID = " + userID);
                    }
                    return b;
                });
            });
        });
    }
    LobbyTools.useItem = useItem;
    function getkv(tableName, key) {
        return __awaiter(this, void 0, void 0, function* () {
            let str = yield rpc_1.Rpc.center.callException("kds.dbp.kv.gett", tableName, key);
            if (str) {
                return JSON.parse(str);
            }
            return str;
        });
    }
    LobbyTools.getkv = getkv;
    function updateItems(userID) {
        return __awaiter(this, void 0, void 0, function* () {
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.get", userID);
            let items = yield rpc_1.Rpc.center.callException("kds.dbp.item.getByUnionID", loginData.unionID);
            yield rpc_1.Rpc.center.callException("kds.nt.changed.user.item", userID, items);
        });
    }
    LobbyTools.updateItems = updateItems;
})(LobbyTools = exports.LobbyTools || (exports.LobbyTools = {}));
