"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const UserDefine_1 = require("../../../kds-base-define/src/UserDefine");
const rpc_1 = require("../rpc");
const utils_1 = require("kdweb-core/lib/utils");
const ServerConfig_1 = require("../../../kds-base-define/src/ServerConfig");
var LoginHeler;
(function (LoginHeler) {
    function getNewUserID() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.ids.getId", "user-login-id", 6000000, 1);
        });
    }
    LoginHeler.getNewUserID = getNewUserID;
    function getNewGuestID() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield rpc_1.Rpc.center.callException("kds.ids.getId", "guest-login-id", 10000, 1);
        });
    }
    LoginHeler.getNewGuestID = getNewGuestID;
    function isPhoneNum(phoneNum) {
        if (/^[1][3,4,5,7,8,9][0-9]{9}$/.test(phoneNum)) {
            return true;
        }
        return false;
    }
    LoginHeler.isPhoneNum = isPhoneNum;
    function getUserLoginData(loginData) {
        loginData = UserDefine_1.UserDefine.getUserSideLoginData(loginData);
        if (loginData.nickName) {
            if (loginData.nickName.length > UserDefine_1.UserDefine.nickNameMaxLen) {
                loginData.nickName.slice(0, UserDefine_1.UserDefine.nickNameMaxLen) + "...";
            }
        }
        return loginData;
    }
    LoginHeler.getUserLoginData = getUserLoginData;
    function getApiIDWithPhone(areaID, phoneNum) {
        return "AREA:" + areaID + "_" + phoneNum;
    }
    LoginHeler.getApiIDWithPhone = getApiIDWithPhone;
    function selectLobbyService() {
        let clients = rpc_1.Rpc.center.clients;
        let lobbys = [];
        for (let client of clients) {
            if (client.name.indexOf("s-lobby") == 0) {
                lobbys.push(client);
            }
        }
        if (lobbys.length == 0) {
            return null;
        }
        let lobby = lobbys[utils_1.kdutils.intRandom(0, lobbys.length)];
        let config = ServerConfig_1.ServerConfig.getConfig(lobby.name);
        return config.other.userHost;
    }
    LoginHeler.selectLobbyService = selectLobbyService;
    function selectSrsNode(userID, areaID) {
        return __awaiter(this, void 0, void 0, function* () {
            let host = null;
            if (areaID != null) {
                host = yield rpc_1.Rpc.center.callException("kds.srs.center.selectNodeHost", userID, areaID);
            }
            else {
                host = yield rpc_1.Rpc.center.callException("kds.srs.center.selectNodeHost", userID);
            }
            return host;
        });
    }
    LoginHeler.selectSrsNode = selectSrsNode;
})(LoginHeler = exports.LoginHeler || (exports.LoginHeler = {}));
