"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const UserDefine_1 = require("../../../kds-base-define/src/UserDefine");
const loginHelper_1 = require("../helper/loginHelper");
const base_1 = require("kdweb-core/lib/service/base");
const utils_1 = require("kdweb-core/lib/utils");
const UserErrorCode_1 = require("../../../kds-base-define/src/UserErrorCode");
const rpc_1 = require("../rpc");
const UserFlag_1 = require("../../../kds-base-define/src/UserFlag");
const KVDefine_1 = require("../../../kds-base-define/src/KVDefine");
const log_1 = require("../log");
let wechatIconPrefix = "https://thirdwx.qlogo.cn";
function operWechatIcon(url) {
    if (url == null) {
        return "NULL";
    }
    if (url.indexOf(wechatIconPrefix) >= 0) {
        url = url.replace("https://thirdwx.qlogo.cn", "https://service.pkgame.com/wechat/img");
        url += "?a=a.jpg";
    }
    return url;
}
var LoginServices;
(function (LoginServices) {
    /**
     *
     * @param params
     * 必选字段：
     * 		areaID,
     * 		accountType,
     * 		deviceType,
     * guest 登录: (Dev带ApiID)
     * 		全选
     * 		accountType == Guest
     * guest 登录: (Wechat等线上环境)
     * 		apiID, 不给则新建
     * 		accountType == Guest
     * Wechat 登录:
     * 		全选
     */
    // 旧版
    // export async function loginChannel(params: {
    // 	apiID: string,
    // 	areaID: string,
    // 	nickName: string,
    // 	iconUrl: string,
    // 	sex: number,
    // 	deviceType: UserDefine.LoginDeviceType,
    // 	accountType?: UserDefine.AccountType,
    // 	openID?: string,
    // 	company?: boolean,
    // }) {
    // 	let loginData: UserDefine.LoginData = null
    // 	if (params.apiID) {
    // 		loginData = await Rpc.center.callException("kds.dbp.user.login.getApiID", params.apiID)
    // 	}
    // 	if (params.iconUrl) {
    // 		params.iconUrl = operWechatIcon(params.iconUrl)
    // 	}
    // 	let time = kdutils.getMillionSecond()
    // 	if (loginData == null) {
    // 		let accountType = params.accountType == null ? UserDefine.AccountType.Wechat : params.accountType
    // 		Log.oth.info("accountType = " + UserDefine.AccountType[accountType])
    // 		if (accountType == UserDefine.AccountType.Guest) {
    // 			// 线上环境下的不带apiID游客登录
    // 			if (params.apiID == null) {
    // 				let guestID = await LoginHeler.getNewGuestID()
    // 				if (guestID == null) {
    // 					return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取ID")
    // 				}
    // 				let apiID = "guestapi_" + guestID
    // 				let userID = await LoginHeler.getNewUserID()
    // 				loginData = {
    // 					apiID: apiID,
    // 					areaID: params.areaID,
    // 					openID: params.openID,
    // 					userID: userID,
    // 					sk: await Rpc.center.callException("kds.access.createSK", apiID + userID),
    // 					nickName: "游客" + guestID,
    // 					sex: 0,
    // 					iconUrl: "NULL",
    // 					account: null,
    // 					phoneNumber: null,
    // 					deviceType: params.deviceType,
    // 					accountType: UserDefine.AccountType.Guest,
    // 					pwdMd5: null,
    // 					regTimestamp: time,
    // 					regDate: kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
    // 				}
    // 			} else {
    // 				let guestID = await LoginHeler.getNewGuestID()
    // 				if (guestID == null) {
    // 					return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取ID")
    // 				}
    // 				// 开发模式下的带apiID游客登录
    // 				loginData = {
    // 					apiID: params.apiID,
    // 					areaID: params.areaID,
    // 					openID: params.openID,
    // 					userID: await LoginHeler.getNewUserID(),
    // 					sk: await Rpc.center.callException("kds.access.createSK", params.apiID),
    // 					nickName: params.nickName || "游客" + guestID,
    // 					sex: params.sex || 0,
    // 					iconUrl: params.iconUrl || "NULL",
    // 					account: null,
    // 					phoneNumber: null,
    // 					deviceType: params.deviceType,
    // 					accountType: accountType,
    // 					pwdMd5: null,
    // 					regTimestamp: time,
    // 					regDate: kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
    // 				}
    // 			}
    // 		} else {
    // 			// if (params.nickName == null) {
    // 			// 	let guestID = await LoginHeler.getNewGuestID()
    // 			// 	if (guestID == null) {
    // 			// 		return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取ID")
    // 			// 	}
    // 			// 	params.nickName = "游客" + guestID
    // 			// 	params.sex = 0
    // 			// 	params.iconUrl = "NULL"
    // 			// }
    // 			loginData = {
    // 				apiID: params.apiID,
    // 				areaID: params.areaID,
    // 				openID: params.openID,
    // 				userID: await LoginHeler.getNewUserID(),
    // 				sk: await Rpc.center.callException("kds.access.createSK", params.apiID),
    // 				nickName: params.nickName,
    // 				sex: params.sex,
    // 				iconUrl: params.iconUrl,
    // 				account: null,
    // 				phoneNumber: null,
    // 				deviceType: params.deviceType,
    // 				accountType: accountType,
    // 				pwdMd5: null,
    // 				regTimestamp: time,
    // 				regDate: kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
    // 			}
    // 			let iconData = {
    // 				gameName: "WM-GZ",
    // 				content: params.iconUrl,
    // 				openid: loginData.openID,
    // 				media_type: 2,
    // 				apiID: loginData.apiID
    // 			}
    // 			await WechatService.iconUrlS(iconData)
    // 			loginData.iconUrl = "NULL";
    // 			let data = {
    // 				gameName: "WM-GZ",
    // 				content: params.nickName,
    // 				apiID: loginData.apiID,
    // 			}
    // 			let n = await WechatService.UnickName(data)
    // 			if (n) {
    // 				loginData.nickName = params.nickName;
    // 			} else {
    // 				let guestID = await LoginHeler.getNewGuestID()
    // 				if (guestID == null) {
    // 					return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取ID")
    // 				}
    // 				loginData.nickName = "游客" + guestID
    // 			}
    // 		}
    // 		loginData['lastLoginDate'] = kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time);
    // 		loginData['lastLoginTimestamp'] = time;
    // 		let b = await Rpc.center.callException("kds.dbp.user.login.new", loginData)
    // 		if (!b) {
    // 			return baseService.errJson(UserErrorCode.ErrorLogin, "用户创建失败")
    // 		}
    // 	} else {
    // 		let changed = false
    // 		// if (loginData.nickName == null) {
    // 		// 	changed = true
    // 		// 	let guestID = await LoginHeler.getNewGuestID()
    // 		// 	if (guestID == null) {
    // 		// 		return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取ID")
    // 		// 	}
    // 		// 	loginData.nickName = "游客" + guestID
    // 		// 	loginData.sex = 0
    // 		// 	loginData.iconUrl = "NULL"
    // 		// }
    // 		loginData['lastLoginDate'] = kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time);
    // 		loginData['lastLoginTimestamp'] = time;
    // 		// let keys = ["nickName","iconUrl","sex","deviceType","accountType"]
    // 		let keys = ["sex", "deviceType", "accountType"]
    // 		for (let key of keys) {
    // 			let v = params[key]
    // 			if (v != null && v != loginData[key]) {
    // 				loginData[key] = v
    // 				// changed = true
    // 			}
    // 		}
    // 		Log.oth.info('getApiID =>', JSON.stringify(loginData))
    // 		if (changed) {
    // 			loginData.nickName = params.nickName
    // 			loginData.iconUrl = params.iconUrl
    // 			loginData.deviceType = params.deviceType
    // 			loginData.accountType = params.accountType == null ? UserDefine.AccountType.Wechat : params.accountType
    // 			await Rpc.center.callException("kds.dbp.user.login.update", loginData)
    // 		}
    // 	}
    // 	if (params.company) {
    // 		await Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag.CompanyTest, true)
    // 	} else {
    // 		await Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag.CompanyTest, false)
    // 	}
    // 	let srsHost: string = null
    // 	if (loginData.accountType == UserDefine.AccountType.Guest) {
    // 		srsHost = await LoginHeler.selectSrsNode(loginData.userID, params.areaID)
    // 	} else {
    // 		srsHost = await LoginHeler.selectSrsNode(loginData.userID, loginData.areaID)
    // 	}
    // 	if (srsHost == null) {
    // 		return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取网关服务，请稍后再试")
    // 	}
    // 	let lobbyHost = LoginHeler.selectLobbyService()
    // 	if (lobbyHost == null) {
    // 		return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取大厅服务，请稍后再试")
    // 	}
    // 	Rpc.center.call("kds.dbp.record.login", loginData.userID, "0.0.0.0", UserDefine.LoginDeviceType[loginData.deviceType], null)
    // 	let ak = await Rpc.center.callException("kds.access.createAK", loginData.sk + "|" + loginData.userID)
    // 	if (loginData.accountType == UserDefine.AccountType.Wechat && params.openID) {
    // 		Rpc.center.callException("kds.dbp.kv.sett", KVDefine.WXUserID2OpenIDTablename, KVDefine.WXUserID2OpenIDPrefix + loginData.userID, params.openID)
    // 	} else {
    // 		Rpc.center.callException("kds.dbp.kv.delt", KVDefine.WXUserID2OpenIDTablename, KVDefine.WXUserID2OpenIDPrefix + loginData.userID)
    // 	}
    // 	return {
    // 		accessToken: ak,
    // 		loginData: LoginHeler.getUserLoginData(loginData),
    // 		lobbyHost: lobbyHost,
    // 		srsHost: srsHost,
    // 	}
    // }
    // 新版
    // export async function loginChannel(params: {
    // 	apiID: string,
    // 	areaID: string,
    // 	nickName: string,
    // 	iconUrl: string,
    // 	sex: number,
    // 	deviceType: UserDefine.LoginDeviceType,
    // 	accountType?: UserDefine.AccountType,
    // 	openID?: string,
    // 	company?: boolean,
    // }) {
    // 	let loginData: UserDefine.LoginData = null
    // 	if (params.apiID) {
    // 		loginData = await Rpc.center.callException("kds.dbp.user.login.getApiID", params.apiID)
    // 	}
    // 	if (params.iconUrl) {
    // 		params.iconUrl = operWechatIcon(params.iconUrl)
    // 	}
    // 	let time = kdutils.getMillionSecond()
    // 	if (loginData == null) {
    // 		let accountType = params.accountType == null ? UserDefine.AccountType.Wechat : params.accountType
    // 		Log.oth.info("accountType = " + UserDefine.AccountType[accountType])
    // 		if (accountType == UserDefine.AccountType.Guest) {
    // 			// 线上环境下的不带apiID游客登录
    // 			if (params.apiID == null) {
    // 				let guestID = await LoginHeler.getNewGuestID()
    // 				if (guestID == null) {
    // 					return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取ID")
    // 				}
    // 				let apiID = "guestapi_" + guestID
    // 				let userID = await LoginHeler.getNewUserID()
    // 				loginData = {
    // 					apiID: apiID,
    // 					areaID: params.areaID,
    // 					openID: params.openID,
    // 					userID: userID,
    // 					sk: await Rpc.center.callException("kds.access.createSK", apiID + userID),
    // 					nickName: "游客" + guestID,
    // 					sex: 0,
    // 					iconUrl: "NULL",
    // 					account: null,
    // 					phoneNumber: null,
    // 					deviceType: params.deviceType,
    // 					accountType: UserDefine.AccountType.Guest,
    // 					pwdMd5: null,
    // 					regTimestamp: time,
    // 					regDate: kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
    // 				}
    // 			} else {
    // 				let guestID = await LoginHeler.getNewGuestID()
    // 				if (guestID == null) {
    // 					return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取ID")
    // 				}
    // 				// 开发模式下的带apiID游客登录
    // 				loginData = {
    // 					apiID: params.apiID,
    // 					areaID: params.areaID,
    // 					openID: params.openID,
    // 					userID: await LoginHeler.getNewUserID(),
    // 					sk: await Rpc.center.callException("kds.access.createSK", params.apiID),
    // 					nickName: params.nickName || "游客" + guestID,
    // 					sex: params.sex || 0,
    // 					iconUrl: params.iconUrl || "NULL",
    // 					account: null,
    // 					phoneNumber: null,
    // 					deviceType: params.deviceType,
    // 					accountType: accountType,
    // 					pwdMd5: null,
    // 					regTimestamp: time,
    // 					regDate: kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
    // 				}
    // 			}
    // 		} else {
    // 			if (params.nickName == null) {
    // 				let guestID = await LoginHeler.getNewGuestID()
    // 				if (guestID == null) {
    // 					return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取ID")
    // 				}
    // 				params.nickName = "游客" + guestID
    // 				params.sex = 0
    // 				params.iconUrl = "NULL"
    // 			}
    // 			loginData = {
    // 				apiID: params.apiID,
    // 				areaID: params.areaID,
    // 				openID: params.openID,
    // 				userID: await LoginHeler.getNewUserID(),
    // 				sk: await Rpc.center.callException("kds.access.createSK", params.apiID),
    // 				nickName: params.nickName,
    // 				sex: params.sex,
    // 				iconUrl: "NULL",
    // 				account: null,
    // 				phoneNumber: null,
    // 				deviceType: params.deviceType,
    // 				accountType: accountType,
    // 				pwdMd5: null,
    // 				regTimestamp: time,
    // 				regDate: kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
    // 			}
    // 		}
    // 		loginData['lastLoginDate'] = kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time);
    // 		loginData['lastLoginTimestamp'] = time;
    // 		let b = await Rpc.center.callException("kds.dbp.user.login.new", loginData)
    // 		if (!b) {
    // 			return baseService.errJson(UserErrorCode.ErrorLogin, "用户创建失败")
    // 		}
    // 	} else {
    // 		let changed = false
    // 		if (loginData.nickName == null) {
    // 			changed = true
    // 			let guestID = await LoginHeler.getNewGuestID()
    // 			if (guestID == null) {
    // 				return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取ID")
    // 			}
    // 			loginData.nickName = "游客" + guestID
    // 			loginData.sex = 0
    // 			loginData.iconUrl = "NULL"
    // 		}
    // 		loginData['lastLoginDate'] = kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time);
    // 		loginData['lastLoginTimestamp'] = time;
    // 		// let keys = ["nickName","iconUrl","sex","deviceType","accountType"]
    // 		let keys = ["sex", "deviceType", "accountType"]
    // 		for (let key of keys) {
    // 			let v = params[key]
    // 			if (v != null && v != loginData[key]) {
    // 				loginData[key] = v
    // 				changed = true
    // 			}
    // 		}
    // 		// if (changed) {
    // 		// loginData.nickName = params.nickName
    // 		// loginData.iconUrl = params.iconUrl
    // 		// loginData.sex = params.sex
    // 		loginData.deviceType = params.deviceType
    // 		loginData.accountType = params.accountType == null ? UserDefine.AccountType.Wechat : params.accountType
    // 		await Rpc.center.callException("kds.dbp.user.login.update", loginData)
    // 		// }
    // 	}
    // 	if (params.company) {
    // 		await Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag.CompanyTest, true)
    // 	} else {
    // 		await Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag.CompanyTest, false)
    // 	}
    // 	let srsHost: string = null
    // 	if (loginData.accountType == UserDefine.AccountType.Guest) {
    // 		srsHost = await LoginHeler.selectSrsNode(loginData.userID, params.areaID)
    // 	} else {
    // 		srsHost = await LoginHeler.selectSrsNode(loginData.userID, loginData.areaID)
    // 	}
    // 	if (srsHost == null) {
    // 		return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取网关服务，请稍后再试")
    // 	}
    // 	let lobbyHost = LoginHeler.selectLobbyService()
    // 	if (lobbyHost == null) {
    // 		return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取大厅服务，请稍后再试")
    // 	}
    // 	Rpc.center.call("kds.dbp.record.login", loginData.userID, "0.0.0.0", UserDefine.LoginDeviceType[loginData.deviceType], null)
    // 	let ak = await Rpc.center.callException("kds.access.createAK", loginData.sk + "|" + loginData.userID)
    // 	if (loginData.accountType == UserDefine.AccountType.Wechat && params.openID) {
    // 		Rpc.center.callException("kds.dbp.kv.sett", KVDefine.WXUserID2OpenIDTablename, KVDefine.WXUserID2OpenIDPrefix + loginData.userID, params.openID)
    // 	} else {
    // 		Rpc.center.callException("kds.dbp.kv.delt", KVDefine.WXUserID2OpenIDTablename, KVDefine.WXUserID2OpenIDPrefix + loginData.userID)
    // 	}
    // 	return {
    // 		accessToken: ak,
    // 		loginData: LoginHeler.getUserLoginData(loginData),
    // 		lobbyHost: lobbyHost,
    // 		srsHost: srsHost,
    // 	}
    // }
    // h5版
    // export async function loginChannel(params: {
    // 	apiID: string,
    // 	areaID: string,
    // 	nickName: string,
    // 	iconUrl: string,
    // 	sex: number,
    // 	deviceType: UserDefine.LoginDeviceType,
    // 	accountType?: UserDefine.AccountType,
    // 	openID?: string,
    // 	company?: boolean,
    // 	phoneNumber: string,
    // 	pwdMd5: string
    // }) {
    // 	let loginData: UserDefine.LoginData = null
    // 	// if (params.apiID) {
    // 	// 	loginData = await Rpc.center.callException("kds.dbp.user.login.getApiID", params.apiID)
    // 	// }
    // 	// if(!params.hasOwnProperty('phoneNumber') || !params.hasOwnProperty('pwdMd5')) {
    // 	// 	return baseService.errJson(UserErrorCode.ErrorLogin, "登录参数错误，请检查后重试")
    // 	// }
    // 	if (params.phoneNumber) {
    // 		loginData = await Rpc.center.callException("kds.dbp.user.login.getPhone", params.phoneNumber)
    // 	}
    // 	if (params.iconUrl) {
    // 		params.iconUrl = operWechatIcon(params.iconUrl)
    // 	}
    // 	let time = kdutils.getMillionSecond()
    // 	if (loginData == null) {
    // 		let accountType = params.accountType == null ? UserDefine.AccountType.Wechat : params.accountType
    // 		Log.oth.info("accountType = " + UserDefine.AccountType[accountType])
    // 		let guestID = await LoginHeler.getNewGuestID()
    // 		if (guestID == null) {
    // 			return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取ID")
    // 		}
    // 		let apiID = "guestapi_" + guestID
    // 		let userID = await LoginHeler.getNewUserID()
    // 		loginData = {
    // 			apiID: apiID,
    // 			areaID: params.areaID,
    // 			openID: params.openID,
    // 			userID: userID,
    // 			sk: await Rpc.center.callException("kds.access.createSK", apiID + userID),
    // 			nickName: "游客" + guestID,
    // 			sex: 0,
    // 			iconUrl: "NULL",
    // 			account: null,
    // 			phoneNumber: params.phoneNumber,
    // 			deviceType: params.deviceType,
    // 			accountType: UserDefine.AccountType.Guest,
    // 			pwdMd5: params.pwdMd5,
    // 			regTimestamp: time,
    // 			regDate: kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
    // 		}
    // 		loginData['lastLoginDate'] = kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time);
    // 		loginData['lastLoginTimestamp'] = time;
    // 		let b = await Rpc.center.callException("kds.dbp.user.login.new", loginData)
    // 		if (!b) {
    // 			return baseService.errJson(UserErrorCode.ErrorLogin, "用户创建失败")
    // 		}
    // 	} else {
    // 		let changed = false
    // 		if(params.deviceType == UserDefine.LoginDeviceType.H5) {
    // 			if(loginData.pwdMd5 != params.pwdMd5) {
    // 				return baseService.errJson(UserErrorCode.ErrorLogin, "手机号或密码错误")
    // 			}
    // 		}
    // 		if (loginData.nickName == null) {
    // 			changed = true
    // 			let guestID = await LoginHeler.getNewGuestID()
    // 			if (guestID == null) {
    // 				return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取ID")
    // 			}
    // 			loginData.nickName = "游客" + guestID
    // 			loginData.sex = 0
    // 			loginData.iconUrl = "NULL"
    // 		}
    // 		loginData['lastLoginDate'] = kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time);
    // 		loginData['lastLoginTimestamp'] = time;
    // 		// let keys = ["nickName","iconUrl","sex","deviceType","accountType"]
    // 		let keys = ["sex", "deviceType", "accountType"]
    // 		for (let key of keys) {
    // 			let v = params[key]
    // 			if (v != null && v != loginData[key]) {
    // 				loginData[key] = v
    // 				changed = true
    // 			}
    // 		}
    // 		// if (changed) {
    // 		// loginData.nickName = params.nickName
    // 		// loginData.iconUrl = params.iconUrl
    // 		// loginData.sex = params.sex
    // 		loginData.deviceType = params.deviceType
    // 		loginData.accountType = params.accountType == null ? UserDefine.AccountType.Wechat : params.accountType
    // 		await Rpc.center.callException("kds.dbp.user.login.update", loginData)
    // 		// }
    // 	}
    // 	if (params.company) {
    // 		await Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag.CompanyTest, true)
    // 	} else {
    // 		await Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag.CompanyTest, false)
    // 	}
    // 	let srsHost: string = null
    // 	if (loginData.accountType == UserDefine.AccountType.Guest) {
    // 		srsHost = await LoginHeler.selectSrsNode(loginData.userID, params.areaID)
    // 	} else {
    // 		srsHost = await LoginHeler.selectSrsNode(loginData.userID, loginData.areaID)
    // 	}
    // 	if (srsHost == null) {
    // 		return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取网关服务，请稍后再试")
    // 	}
    // 	let lobbyHost = LoginHeler.selectLobbyService()
    // 	if (lobbyHost == null) {
    // 		return baseService.errJson(UserErrorCode.ErrorLogin, "无法获取大厅服务，请稍后再试")
    // 	}
    // 	Rpc.center.call("kds.dbp.record.login", loginData.userID, "0.0.0.0", UserDefine.LoginDeviceType[loginData.deviceType], null)
    // 	let ak = await Rpc.center.callException("kds.access.createAK", loginData.sk + "|" + loginData.userID)
    // 	if (loginData.accountType == UserDefine.AccountType.Wechat && params.openID) {
    // 		Rpc.center.callException("kds.dbp.kv.sett", KVDefine.WXUserID2OpenIDTablename, KVDefine.WXUserID2OpenIDPrefix + loginData.userID, params.openID)
    // 	} else {
    // 		Rpc.center.callException("kds.dbp.kv.delt", KVDefine.WXUserID2OpenIDTablename, KVDefine.WXUserID2OpenIDPrefix + loginData.userID)
    // 	}
    // 	return {
    // 		accessToken: ak,
    // 		loginData: LoginHeler.getUserLoginData(loginData),
    // 		lobbyHost: lobbyHost,
    // 		srsHost: srsHost,
    // 	}
    // }
    function loginChannel(params) {
        return __awaiter(this, void 0, void 0, function* () {
            let data = null;
            if (params.deviceType == UserDefine_1.UserDefine.LoginDeviceType.H5) {
                data = yield loginH5(params);
            }
            else {
                data = yield this.loginWechat(params);
            }
            return data;
        });
    }
    LoginServices.loginChannel = loginChannel;
    function loginH5(params) {
        return __awaiter(this, void 0, void 0, function* () {
            let loginData = null;
            // if (params.apiID) {
            // 	loginData = await Rpc.center.callException("kds.dbp.user.login.getApiID", params.apiID)
            // }
            // if(!params.hasOwnProperty('phoneNumber') || !params.hasOwnProperty('pwdMd5')) {
            // 	return baseService.errJson(UserErrorCode.ErrorLogin, "登录参数错误，请检查后重试")
            // }
            if (params.phoneNumber) {
                loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.getPhone", params.phoneNumber);
            }
            if (params.iconUrl) {
                params.iconUrl = operWechatIcon(params.iconUrl);
            }
            let time = utils_1.kdutils.getMillionSecond();
            if (loginData == null) {
                let accountType = params.accountType == null ? UserDefine_1.UserDefine.AccountType.Wechat : params.accountType;
                log_1.Log.oth.info("accountType = " + UserDefine_1.UserDefine.AccountType[accountType]);
                let guestID = yield loginHelper_1.LoginHeler.getNewGuestID();
                if (guestID == null) {
                    return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取ID");
                }
                let apiID = "guestapi_" + guestID;
                let userID = yield loginHelper_1.LoginHeler.getNewUserID();
                loginData = {
                    apiID: apiID,
                    areaID: params.areaID,
                    openID: params.openID,
                    userID: userID,
                    sk: yield rpc_1.Rpc.center.callException("kds.access.createSK", apiID + userID),
                    nickName: "游客" + guestID,
                    sex: 0,
                    iconUrl: "NULL",
                    account: null,
                    phoneNumber: params.phoneNumber,
                    deviceType: params.deviceType,
                    accountType: UserDefine_1.UserDefine.AccountType.Guest,
                    pwdMd5: params.pwdMd5,
                    regTimestamp: time,
                    regDate: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
                };
                loginData['lastLoginDate'] = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time);
                loginData['lastLoginTimestamp'] = time;
                let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.new", loginData);
                if (!b) {
                    return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "用户创建失败");
                }
            }
            else {
                let changed = false;
                if (params.deviceType == UserDefine_1.UserDefine.LoginDeviceType.H5) {
                    if (loginData.pwdMd5 != params.pwdMd5) {
                        return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "手机号或密码错误");
                    }
                }
                if (loginData.nickName == null) {
                    changed = true;
                    let guestID = yield loginHelper_1.LoginHeler.getNewGuestID();
                    if (guestID == null) {
                        return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取ID");
                    }
                    loginData.nickName = "游客" + guestID;
                    loginData.sex = 0;
                    loginData.iconUrl = "NULL";
                }
                loginData['lastLoginDate'] = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time);
                loginData['lastLoginTimestamp'] = time;
                // let keys = ["nickName","iconUrl","sex","deviceType","accountType"]
                let keys = ["sex", "deviceType", "accountType"];
                for (let key of keys) {
                    let v = params[key];
                    if (v != null && v != loginData[key]) {
                        loginData[key] = v;
                        changed = true;
                    }
                }
                // if (changed) {
                // loginData.nickName = params.nickName
                // loginData.iconUrl = params.iconUrl
                // loginData.sex = params.sex
                loginData.deviceType = params.deviceType;
                loginData.accountType = params.accountType == null ? UserDefine_1.UserDefine.AccountType.Wechat : params.accountType;
                yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", loginData);
                // }
            }
            if (params.company) {
                yield rpc_1.Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag_1.UserFlag.CompanyTest, true);
            }
            else {
                yield rpc_1.Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag_1.UserFlag.CompanyTest, false);
            }
            let srsHost = null;
            if (loginData.accountType == UserDefine_1.UserDefine.AccountType.Guest) {
                srsHost = yield loginHelper_1.LoginHeler.selectSrsNode(loginData.userID, params.areaID);
            }
            else {
                srsHost = yield loginHelper_1.LoginHeler.selectSrsNode(loginData.userID, loginData.areaID);
            }
            if (srsHost == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取网关服务，请稍后再试");
            }
            let lobbyHost = loginHelper_1.LoginHeler.selectLobbyService();
            if (lobbyHost == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取大厅服务，请稍后再试");
            }
            rpc_1.Rpc.center.call("kds.dbp.record.login", loginData.userID, "0.0.0.0", UserDefine_1.UserDefine.LoginDeviceType[loginData.deviceType], null);
            let ak = yield rpc_1.Rpc.center.callException("kds.access.createAK", loginData.sk + "|" + loginData.userID);
            if (loginData.accountType == UserDefine_1.UserDefine.AccountType.Wechat && params.openID) {
                rpc_1.Rpc.center.callException("kds.dbp.kv.sett", KVDefine_1.KVDefine.WXUserID2OpenIDTablename, KVDefine_1.KVDefine.WXUserID2OpenIDPrefix + loginData.userID, params.openID);
            }
            else {
                rpc_1.Rpc.center.callException("kds.dbp.kv.delt", KVDefine_1.KVDefine.WXUserID2OpenIDTablename, KVDefine_1.KVDefine.WXUserID2OpenIDPrefix + loginData.userID);
            }
            return {
                accessToken: ak,
                loginData: loginHelper_1.LoginHeler.getUserLoginData(loginData),
                lobbyHost: lobbyHost,
                srsHost: srsHost,
            };
        });
    }
    LoginServices.loginH5 = loginH5;
    function loginWechat(params) {
        return __awaiter(this, void 0, void 0, function* () {
            let loginData = null;
            if (params.apiID) {
                loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.getApiID", params.apiID);
            }
            if (params.iconUrl) {
                params.iconUrl = operWechatIcon(params.iconUrl);
            }
            let time = utils_1.kdutils.getMillionSecond();
            if (loginData == null) {
                let accountType = params.accountType == null ? UserDefine_1.UserDefine.AccountType.Wechat : params.accountType;
                log_1.Log.oth.info("accountType = " + UserDefine_1.UserDefine.AccountType[accountType]);
                if (accountType == UserDefine_1.UserDefine.AccountType.Guest) {
                    // 线上环境下的不带apiID游客登录
                    if (params.apiID == null) {
                        let guestID = yield loginHelper_1.LoginHeler.getNewGuestID();
                        if (guestID == null) {
                            return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取ID");
                        }
                        let apiID = "guestapi_" + guestID;
                        let userID = yield loginHelper_1.LoginHeler.getNewUserID();
                        loginData = {
                            apiID: apiID,
                            areaID: params.areaID,
                            openID: params.openID,
                            userID: userID,
                            sk: yield rpc_1.Rpc.center.callException("kds.access.createSK", apiID + userID),
                            nickName: "游客" + guestID,
                            sex: 0,
                            iconUrl: "NULL",
                            account: null,
                            phoneNumber: null,
                            deviceType: params.deviceType,
                            accountType: UserDefine_1.UserDefine.AccountType.Guest,
                            pwdMd5: null,
                            regTimestamp: time,
                            regDate: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
                        };
                    }
                    else {
                        let guestID = yield loginHelper_1.LoginHeler.getNewGuestID();
                        if (guestID == null) {
                            return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取ID");
                        }
                        // 开发模式下的带apiID游客登录
                        loginData = {
                            apiID: params.apiID,
                            areaID: params.areaID,
                            openID: params.openID,
                            userID: yield loginHelper_1.LoginHeler.getNewUserID(),
                            sk: yield rpc_1.Rpc.center.callException("kds.access.createSK", params.apiID),
                            nickName: params.nickName || "游客" + guestID,
                            sex: params.sex || 0,
                            iconUrl: params.iconUrl || "NULL",
                            account: null,
                            phoneNumber: null,
                            deviceType: params.deviceType,
                            accountType: accountType,
                            pwdMd5: null,
                            regTimestamp: time,
                            regDate: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
                        };
                    }
                }
                else {
                    if (params.nickName == null) {
                        let guestID = yield loginHelper_1.LoginHeler.getNewGuestID();
                        if (guestID == null) {
                            return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取ID");
                        }
                        params.nickName = "游客" + guestID;
                        params.sex = 0;
                        params.iconUrl = "NULL";
                    }
                    loginData = {
                        apiID: params.apiID,
                        areaID: params.areaID,
                        openID: params.openID,
                        userID: yield loginHelper_1.LoginHeler.getNewUserID(),
                        sk: yield rpc_1.Rpc.center.callException("kds.access.createSK", params.apiID),
                        nickName: params.nickName,
                        sex: params.sex,
                        iconUrl: "NULL",
                        account: null,
                        phoneNumber: null,
                        deviceType: params.deviceType,
                        accountType: accountType,
                        pwdMd5: null,
                        regTimestamp: time,
                        regDate: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
                    };
                }
                loginData['lastLoginDate'] = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time);
                loginData['lastLoginTimestamp'] = time;
                let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.new", loginData);
                if (!b) {
                    return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "用户创建失败");
                }
            }
            else {
                let changed = false;
                if (loginData.nickName == null) {
                    changed = true;
                    let guestID = yield loginHelper_1.LoginHeler.getNewGuestID();
                    if (guestID == null) {
                        return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取ID");
                    }
                    loginData.nickName = "游客" + guestID;
                    loginData.sex = 0;
                    loginData.iconUrl = "NULL";
                }
                loginData['lastLoginDate'] = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time);
                loginData['lastLoginTimestamp'] = time;
                // let keys = ["nickName","iconUrl","sex","deviceType","accountType"]
                let keys = ["sex", "deviceType", "accountType"];
                for (let key of keys) {
                    let v = params[key];
                    if (v != null && v != loginData[key]) {
                        loginData[key] = v;
                        changed = true;
                    }
                }
                // if (changed) {
                // loginData.nickName = params.nickName
                // loginData.iconUrl = params.iconUrl
                // loginData.sex = params.sex
                loginData.deviceType = params.deviceType;
                loginData.accountType = params.accountType == null ? UserDefine_1.UserDefine.AccountType.Wechat : params.accountType;
                yield rpc_1.Rpc.center.callException("kds.dbp.user.login.update", loginData);
                // }
            }
            if (params.company) {
                yield rpc_1.Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag_1.UserFlag.CompanyTest, true);
            }
            else {
                yield rpc_1.Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag_1.UserFlag.CompanyTest, false);
            }
            let srsHost = null;
            if (loginData.accountType == UserDefine_1.UserDefine.AccountType.Guest) {
                srsHost = yield loginHelper_1.LoginHeler.selectSrsNode(loginData.userID, params.areaID);
            }
            else {
                srsHost = yield loginHelper_1.LoginHeler.selectSrsNode(loginData.userID, loginData.areaID);
            }
            if (srsHost == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取网关服务，请稍后再试");
            }
            let lobbyHost = loginHelper_1.LoginHeler.selectLobbyService();
            if (lobbyHost == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取大厅服务，请稍后再试");
            }
            rpc_1.Rpc.center.call("kds.dbp.record.login", loginData.userID, "0.0.0.0", UserDefine_1.UserDefine.LoginDeviceType[loginData.deviceType], null);
            let ak = yield rpc_1.Rpc.center.callException("kds.access.createAK", loginData.sk + "|" + loginData.userID);
            if (loginData.accountType == UserDefine_1.UserDefine.AccountType.Wechat && params.openID) {
                rpc_1.Rpc.center.callException("kds.dbp.kv.sett", KVDefine_1.KVDefine.WXUserID2OpenIDTablename, KVDefine_1.KVDefine.WXUserID2OpenIDPrefix + loginData.userID, params.openID);
            }
            else {
                rpc_1.Rpc.center.callException("kds.dbp.kv.delt", KVDefine_1.KVDefine.WXUserID2OpenIDTablename, KVDefine_1.KVDefine.WXUserID2OpenIDPrefix + loginData.userID);
            }
            return {
                accessToken: ak,
                loginData: loginHelper_1.LoginHeler.getUserLoginData(loginData),
                lobbyHost: lobbyHost,
                srsHost: srsHost,
            };
        });
    }
    LoginServices.loginWechat = loginWechat;
    function loginAccount(params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!loginHelper_1.LoginHeler.isPhoneNum(params.phoneNumber)) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WrongPhoneNumber, "电话号码错误");
            }
            let apiID = loginHelper_1.LoginHeler.getApiIDWithPhone(params.areaID, params.phoneNumber);
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.getApiID", apiID);
            if (loginData == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_NoAccount, "用户不存在");
            }
            if (loginData.pwdMd5 != params.pwdMd5) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WrongPassword, "密码错误");
            }
            if (params.company) {
                yield rpc_1.Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag_1.UserFlag.CompanyTest, true);
            }
            else {
                yield rpc_1.Rpc.center.callException("kds.dbp.user.flag.set", loginData.userID, UserFlag_1.UserFlag.CompanyTest, false);
            }
            let srsHost = yield loginHelper_1.LoginHeler.selectSrsNode(loginData.userID, loginData.areaID);
            if (srsHost == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取网关服务，请稍后再试");
            }
            let lobbyHost = loginHelper_1.LoginHeler.selectLobbyService();
            if (lobbyHost == null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取大厅服务，请稍后再试");
            }
            rpc_1.Rpc.center.call("kds.dbp.record.login", loginData.userID, "0.0.0.0", UserDefine_1.UserDefine.LoginDeviceType[loginData.deviceType], null);
            let ak = yield rpc_1.Rpc.center.callException("kds.access.createAK", loginData.sk + "|" + loginData.userID);
            rpc_1.Rpc.center.callException("kds.dbp.kv.delt", KVDefine_1.KVDefine.WXUserID2OpenIDTablename, KVDefine_1.KVDefine.WXUserID2OpenIDPrefix + loginData.userID);
            return {
                accessToken: ak,
                loginData: loginHelper_1.LoginHeler.getUserLoginData(loginData),
                lobbyHost: lobbyHost,
                srsHost: srsHost,
            };
        });
    }
    LoginServices.loginAccount = loginAccount;
    function regAccount(params) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!loginHelper_1.LoginHeler.isPhoneNum(params.phoneNumber)) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Login_WrongPhoneNumber, "手机号码错误");
            }
            let apiID = loginHelper_1.LoginHeler.getApiIDWithPhone(params.areaID, params.phoneNumber);
            let loginData = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.getApiID", apiID);
            if (loginData != null) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Register_Exist, "注册失败");
            }
            let time = utils_1.kdutils.getMillionSecond();
            let guestID = -1;
            if (params.nickName == null) {
                guestID = yield loginHelper_1.LoginHeler.getNewGuestID();
                if (guestID == null) {
                    return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "无法获取ID");
                }
            }
            loginData = {
                apiID: apiID,
                areaID: params.areaID,
                openID: apiID,
                userID: yield loginHelper_1.LoginHeler.getNewUserID(),
                sk: yield rpc_1.Rpc.center.callException("kds.access.createSK", apiID),
                nickName: params.nickName || ("游客" + guestID),
                sex: params.sex,
                iconUrl: null,
                account: params.phoneNumber,
                phoneNumber: params.phoneNumber,
                deviceType: params.deviceType,
                accountType: UserDefine_1.UserDefine.AccountType.Account,
                pwdMd5: params.pwdMd5,
                regTimestamp: time,
                regDate: utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH-mm-ss", time),
            };
            loginData['lastLoginDate'] = utils_1.kdutils.getFmtMoment("YYYY-MM-DD HH:mm:ss", time);
            loginData['lastLoginTimestamp'] = time;
            let b = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.new", loginData);
            if (!b) {
                return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.ErrorLogin, "用户创建失败");
            }
            return base_1.baseService.errJson(UserErrorCode_1.UserErrorCode.Success);
        });
    }
    LoginServices.regAccount = regAccount;
})(LoginServices = exports.LoginServices || (exports.LoginServices = {}));
