"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const wcore = require("kdweb-core");
const config_1 = require("./config");
const rpc_1 = require("./rpc");
const base_1 = require("kdweb-core/lib/service/base");
const login_1 = require("./service/login");
const wechat_1 = require("./service/wechat");
const try_1 = require("./service/try");
let app = new wcore.service.entity(config_1.Config.myConfig.servicePort);
app.setAllowOrigin();
app.addInstance("/login/channel", base_1.lambdaAsyncService.create(login_1.LoginServices.loginChannel));
app.addInstance("/login/account", base_1.lambdaAsyncService.create(login_1.LoginServices.loginAccount));
app.addInstance("/login/reg", base_1.lambdaAsyncService.create(login_1.LoginServices.regAccount));
app.addInstance("/login/wechat/auth", base_1.lambdaAsyncService.create(wechat_1.WechatService.login));
app.addInstance("/login/try", base_1.lambdaAsyncService.create(try_1.TryService.tryLogin));
app.listen();
rpc_1.Rpc.init();
