"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CardArray = exports.tCard = exports.Card = void 0;
class Card {
    constructor(suit, value) {
        if (suit == null) {
            this.suit = 0;
            this.value = 0;
        }
        else {
            if (typeof (suit) == "number") {
                this.suit = suit;
                this.value = value == null ? 0 : value;
            }
            else {
                this.suit = suit.suit == null ? 0 : suit.suit;
                this.value = suit.value == null ? 0 : suit.value;
            }
        }
        this.serial = 0;
    }
    get obj() {
        let ret = {
            suit: this.suit,
            value: this.value
        };
        return ret;
    }
    get data() {
        return this.suit * 1000 + this.value;
    }
    equal(other) {
        if (other instanceof Card) {
            return this.suit == other.suit && this.value == other.value && this.serial == other.serial;
        }
        return this.suit == other.suit && this.value == other.value;
    }
    clone() {
        return new Card(this);
    }
    static get None() {
        return new Card();
    }
    static obj(suit, value) {
        let ret = {
            suit: 0,
            value: 0,
        };
        if (suit == null) {
            ret.suit = 0;
            ret.value = 0;
        }
        else {
            if (typeof (suit) == "number") {
                ret.suit = suit;
                ret.value = value == null ? 0 : value;
            }
            else {
                ret.suit = suit.suit == null ? 0 : suit.suit;
                ret.value = suit.value == null ? 0 : suit.value;
            }
        }
        return ret;
    }
}
exports.Card = Card;
var tCard;
(function (tCard) {
    function equal(a, b) {
        return a.suit == b.suit && a.value == b.value;
    }
    tCard.equal = equal;
})(tCard = exports.tCard || (exports.tCard = {}));
class CardArray {
    constructor(cards) {
        this.cards_ = [];
        if (cards) {
            if (cards instanceof CardArray) {
                this.cards_ = cards.cards;
            }
            else {
                for (let card of cards) {
                    this.push(card);
                }
            }
        }
    }
    get cards() {
        return this.cards_.slice(0);
    }
    get refCards() {
        return this.cards_;
    }
    get obj() {
        let ret = [];
        for (let card of this.cards_) {
            ret.push(card.obj);
        }
        return ret;
    }
    get length() {
        return this.cards_.length;
    }
    push(card) {
        this.cards_.push(new Card(card));
    }
    pushArray(cards) {
        if (cards instanceof CardArray) {
            for (let i = 0; i < cards.length; i++) {
                this.push(cards.at(i));
            }
        }
        else {
            for (let card of cards) {
                this.push(card);
            }
        }
    }
    setCard(idx, card) {
        if (idx >= this.cards.length) {
            return false;
        }
        this.cards_[idx] = new Card(card);
        return true;
    }
    popBack() {
        if (this.cards_.length == 0) {
            return null;
        }
        let ret = this.cards_.pop();
        return ret;
    }
    popFront() {
        if (this.cards_.length == 0) {
            return null;
        }
        let ret = this.cards_.shift();
        return ret;
    }
    sort(compareFn) {
        this.cards_.sort(compareFn);
    }
    index(card) {
        let idx = 0;
        for (let c of this.cards_) {
            if (c.equal(card)) {
                return idx;
            }
            idx++;
        }
        return -1;
    }
    at(idx) {
        if (idx >= this.cards_.length) {
            return null;
        }
        return this.cards_[idx];
    }
    last() {
        if (this.cards_.length == 0) {
            return null;
        }
        return this.cards_[this.cards_.length - 1];
    }
    remove(idx) {
        if (idx >= this.cards_.length) {
            return null;
        }
        return this.cards_.splice(idx, 1)[0];
    }
    removeCard(card, count) {
        count = count || 1;
        for (let i = 0; i < count; i++) {
            let idx = this.index(card);
            if (!this.remove(idx)) {
                return false;
            }
        }
        return true;
    }
    removeArray(cards) {
        if (cards instanceof CardArray) {
            let count = 0;
            for (let i = 0; i < cards.length; i++) {
                let idx = this.index(cards.at(i));
                if (idx < 0) {
                    continue;
                }
                count++;
                this.remove(idx);
            }
            return count;
        }
        else {
            let count = 0;
            for (let card of cards) {
                let idx = this.index(card);
                if (idx < 0) {
                    continue;
                }
                count++;
                this.remove(idx);
            }
            return count;
        }
    }
    contains(card) {
        let idx = 0;
        for (let c of this.cards_) {
            if (c.equal(card)) {
                return true;
            }
            idx++;
        }
        return false;
    }
    containsArray(cards) {
        if (cards instanceof CardArray) {
            for (let i = 0; i < cards.length; i++) {
                let idx = this.index(cards.at(i));
                if (idx < 0) {
                    return false;
                }
            }
            return true;
        }
        else {
            for (let card of cards) {
                let idx = this.index(card);
                if (idx < 0) {
                    return false;
                }
            }
            return true;
        }
    }
    swap(from, to) {
        let temp = this.cards_[to];
        this.cards_[to] = this.cards_[from];
        this.cards_[from] = temp;
    }
    clear() {
        this.cards_.splice(0);
    }
    clone() {
        return new CardArray(this);
    }
    find(func) {
        for (let c of this.cards_) {
            if (func(c)) {
                return c;
            }
        }
        return null;
    }
    findIndex(func) {
        let idx = 0;
        for (let c of this.cards_) {
            if (func(c)) {
                return idx;
            }
            idx++;
        }
        return idx;
    }
    getCount(func) {
        let count = 0;
        for (let c of this.cards_) {
            if (func(c)) {
                count++;
            }
        }
        return count;
    }
    filter(func) {
        let arr = CardArray.empty;
        for (let c of this.cards_) {
            if (func(c)) {
                arr.push(c);
            }
        }
        return arr;
    }
    each(func) {
        for (let c of this.cards_) {
            func(c);
        }
    }
    getCounts() {
        let ret = new Map();
        for (let card of this.cards_) {
            let data = card.data;
            let n = ret.get(data);
            if (n == null) {
                n = 1;
            }
            else {
                n++;
            }
            ret.set(data, n);
        }
        return ret;
    }
    getValueCounts() {
        let ret = new Map();
        for (let card of this.cards_) {
            let data = card.value;
            let n = ret.get(data);
            if (n == null) {
                n = 1;
            }
            else {
                n++;
            }
            ret.set(data, n);
        }
        return ret;
    }
    static get empty() {
        return new CardArray();
    }
    static obj(cards) {
        let arr = null;
        if (cards instanceof CardArray) {
            arr = [];
            for (let i = 0; i < cards.length; i++) {
                arr.push(cards.at(i));
            }
        }
        else {
            arr = cards;
        }
        return arr;
    }
}
exports.CardArray = CardArray;
