"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MJ = void 0;
var MJ;
(function (MJ) {
    let Suit;
    (function (Suit) {
        Suit[Suit["None"] = 0] = "None";
        Suit[Suit["Begin"] = 1] = "Begin";
        Suit[Suit["End"] = 7] = "End";
        Suit[Suit["Wan"] = 1] = "Wan";
        Suit[Suit["Tiao"] = 2] = "Tiao";
        Suit[Suit["Bing"] = 3] = "Bing";
        Suit[Suit["Feng"] = 4] = "Feng";
        Suit[Suit["Zi"] = 5] = "Zi";
        Suit[Suit["Hua"] = 6] = "Hua";
    })(Suit = MJ.Suit || (MJ.Suit = {}));
    let Value;
    (function (Value) {
        Value[Value["None"] = 0] = "None";
        Value[Value["V1"] = 1] = "V1";
        Value[Value["V2"] = 2] = "V2";
        Value[Value["V3"] = 3] = "V3";
        Value[Value["V4"] = 4] = "V4";
        Value[Value["V5"] = 5] = "V5";
        Value[Value["V6"] = 6] = "V6";
        Value[Value["V7"] = 7] = "V7";
        Value[Value["V8"] = 8] = "V8";
        Value[Value["V9"] = 9] = "V9";
        Value[Value["V10"] = 10] = "V10";
        Value[Value["Dong"] = 1] = "Dong";
        Value[Value["Nan"] = 2] = "Nan";
        Value[Value["Xi"] = 3] = "Xi";
        Value[Value["Bei"] = 4] = "Bei";
        Value[Value["Zhong"] = 1] = "Zhong";
        Value[Value["Fa"] = 2] = "Fa";
        Value[Value["Bai"] = 3] = "Bai";
        Value[Value["HChun"] = 1] = "HChun";
        Value[Value["HXia"] = 2] = "HXia";
        Value[Value["HQiu"] = 3] = "HQiu";
        Value[Value["HDong"] = 4] = "HDong";
        Value[Value["HMei"] = 1] = "HMei";
        Value[Value["HLan"] = 2] = "HLan";
        Value[Value["HJu"] = 3] = "HJu";
        Value[Value["HZhu"] = 4] = "HZhu";
    })(Value = MJ.Value || (MJ.Value = {}));
    let OpenType;
    (function (OpenType) {
        OpenType[OpenType["None"] = 0] = "None";
        OpenType[OpenType["Chi"] = 1] = "Chi";
        OpenType[OpenType["Peng"] = 2] = "Peng";
        OpenType[OpenType["Gang"] = 4] = "Gang";
        OpenType[OpenType["Eye"] = 8] = "Eye";
        OpenType[OpenType["Hu"] = 16] = "Hu";
        OpenType[OpenType["Ting"] = 32] = "Ting";
        OpenType[OpenType["Liang"] = 64] = "Liang";
        OpenType[OpenType["ExLeft"] = 256] = "ExLeft";
        OpenType[OpenType["ExRight"] = 512] = "ExRight";
        OpenType[OpenType["ExCenter"] = 1024] = "ExCenter";
        OpenType[OpenType["ExBySelf"] = 2048] = "ExBySelf";
        OpenType[OpenType["ExPrivate"] = 65536] = "ExPrivate";
        OpenType[OpenType["ExNotInTime"] = 131072] = "ExNotInTime";
        OpenType[OpenType["ExSplitKey"] = 262144] = "ExSplitKey";
        OpenType[OpenType["ExInHand"] = 983040] = "ExInHand";
        // 暗杠
        OpenType[OpenType["CombineAnGang"] = 67588] = "CombineAnGang";
        // 补杠
        OpenType[OpenType["CombineBuGang"] = 2052] = "CombineBuGang";
        // 碰杠
        OpenType[OpenType["CombinePengGang"] = 4] = "CombinePengGang";
        // 过圈补杠
        OpenType[OpenType["CombineGuoQuanGang"] = 133124] = "CombineGuoQuanGang";
        OpenType[OpenType["CombineChiPengGang"] = 7] = "CombineChiPengGang";
        OpenType[OpenType["ChongBao"] = 1048592] = "ChongBao";
        OpenType[OpenType["MoBao"] = 2097168] = "MoBao";
        OpenType[OpenType["ChongXiaoJi"] = 4194320] = "ChongXiaoJi";
        OpenType[OpenType["XiaoJi"] = 8388624] = "XiaoJi";
        //穷胡听牌
        OpenType[OpenType["JiaTing"] = 2097184] = "JiaTing";
        OpenType[OpenType["ChiTing"] = 4194336] = "ChiTing";
        OpenType[OpenType["PengTing"] = 8388640] = "PengTing";
        OpenType[OpenType["ChiJiaTing"] = 16777248] = "ChiJiaTing";
        OpenType[OpenType["PengJiaTing"] = 33554464] = "PengJiaTing";
        //附加位
        OpenType[OpenType["ExChongBao"] = 1048576] = "ExChongBao";
        OpenType[OpenType["ExJia"] = 2097152] = "ExJia";
        OpenType[OpenType["ExChi"] = 4194304] = "ExChi";
        OpenType[OpenType["ExPeng"] = 8388608] = "ExPeng";
        OpenType[OpenType["ExChiJia"] = 16777216] = "ExChiJia";
        OpenType[OpenType["ExPengJia"] = 33554432] = "ExPengJia";
        OpenType[OpenType["CombineChongGang"] = 1050628] = "CombineChongGang";
        OpenType[OpenType["CombineChongAnGang"] = 1116164] = "CombineChongAnGang";
    })(OpenType = MJ.OpenType || (MJ.OpenType = {}));
    /**
     * 100 ~ 200 自定义胡牌番型
     * 200 ~ 400 特殊的胡牌番型
     *
     */
    let HuType;
    (function (HuType) {
        HuType[HuType["Normal"] = 0] = "Normal";
        HuType[HuType["ZiMo"] = 1] = "ZiMo";
        HuType[HuType["DianPao"] = 2] = "DianPao";
        HuType[HuType["ChongBao"] = 3] = "ChongBao";
        HuType[HuType["MoBao"] = 4] = "MoBao";
        HuType[HuType["ChongXiaoJi"] = 5] = "ChongXiaoJi";
        HuType[HuType["XiaoJi"] = 6] = "XiaoJi";
        HuType[HuType["GangKai"] = 90] = "GangKai";
        HuType[HuType["GangChong"] = 91] = "GangChong";
        HuType[HuType["QiangGang"] = 92] = "QiangGang";
        HuType[HuType["Flag_CustomHu"] = 100] = "Flag_CustomHu";
        HuType[HuType["Flag_HuEnd"] = 200] = "Flag_HuEnd";
        HuType[HuType["Flag_Lose"] = 400] = "Flag_Lose";
        HuType[HuType["Lose_GangChong"] = 401] = "Lose_GangChong";
        HuType[HuType["Flag_CustomLose"] = 500] = "Flag_CustomLose";
        HuType[HuType["AddScoreBegin"] = 1000] = "AddScoreBegin";
        HuType[HuType["MingGang"] = 1001] = "MingGang";
        HuType[HuType["AnGang"] = 1002] = "AnGang";
    })(HuType = MJ.HuType || (MJ.HuType = {}));
    MJ.Group9 = 9;
    MJ.Group9_SingleJu = 1;
})(MJ = exports.MJ || (exports.MJ = {}));
