"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OSSEntity = void 0;
let OSS = require("ali-oss");
const request = require("request");
const log_1 = require("kdweb-core/lib/log");
const log_2 = require("../log");
class OSSEntity {
    constructor(params) {
        this.params_ = params;
        this.client_ = new OSS({
            region: this.params_.region,
            bucket: this.params_.bucketName,
            accessKeyId: this.params_.accessKeyId,
            accessKeySecret: this.params_.accessKeySecret,
        });
        this.logger_ = log_1.kdlog.getLogger("oth");
    }
    list(prefix, maxNum) {
        return __awaiter(this, void 0, void 0, function* () {
            let result = yield this.client_.list({
                "prefix": prefix,
                "max-keys": maxNum || 1000,
            });
            return result;
        });
    }
    nextList(list, maxNum) {
        return __awaiter(this, void 0, void 0, function* () {
            if (list.isTruncated) {
                let result = yield this.client_.list({
                    marker: list.nextMarker,
                    "max-keys": maxNum || 1000,
                });
                return result;
            }
            return null;
        });
    }
    listAll(prefix) {
        return __awaiter(this, void 0, void 0, function* () {
            let objects = [];
            try {
                let arr = yield this.list(prefix, 100);
                if (arr == null || arr.objects == null || arr.objects.length == 0) {
                    return [];
                    //return arr.objects
                }
                objects = arr.objects;
                if (arr.objects.length < 100) {
                    return objects;
                }
                while (true) {
                    arr = yield this.nextList(arr, 100);
                    if (arr == null || arr.objects.length == 0) {
                        break;
                    }
                    for (let obj of arr.objects) {
                        objects.push(obj);
                    }
                    if (arr.objects.length < 100) {
                        break;
                    }
                }
            }
            catch (error) {
                log_2.Log.oth.info("error in list oss = " + this.params_.bucketName + " prefix = " + prefix, error);
            }
            return objects;
        });
    }
    upload(name, buffer) {
        return __awaiter(this, void 0, void 0, function* () {
            log_2.Log.oth.info("start to upload oss = " + this.params_.bucketName + " filename = " + name + " len = " + buffer.byteLength + "/bs");
            try {
                let ret = yield this.client_.put(name, buffer);
                return this.params_.cdnPrefix + name;
            }
            catch (error) {
                log_2.Log.oth.info("upload failed name = " + name, error);
            }
            return null;
        });
    }
    downloadCallback(obj, func) {
        let pattern = "aliyuncs.com";
        let useUrl = obj.url;
        if (this.params_.cdnPrefix != null) {
            let pos = useUrl.indexOf(pattern);
            if (pos > 0) {
                useUrl = useUrl.substr(pos + pattern.length);
                useUrl = this.params_.cdnPrefix + useUrl;
            }
        }
        request.get({
            url: useUrl
        }, function (error, res, body) {
            if (error) {
                func(error, res, null);
            }
            else {
                func(null, res, body);
            }
        });
    }
    download(obj) {
        let self = this;
        return new Promise(function (resolved, reject) {
            self.downloadCallback(obj, function (error, res, body) {
                resolved({
                    error: error,
                    body: body,
                    res: res,
                });
            });
        });
    }
    delete(obj) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.client_.delete(obj.name);
                log_2.Log.oth.info("delete obj name = ", obj.name);
            }
            catch (error) {
                log_2.Log.oth.info("delete obj failed name = " + obj.name, " | error = ", error);
                return false;
            }
            return true;
        });
    }
    deleteMulti(objs) {
        return __awaiter(this, void 0, void 0, function* () {
            let names = [];
            for (let obj of objs) {
                names.push(obj.name);
            }
            log_2.Log.oth.info("try delete obj length = ", objs.length);
            log_2.Log.oth.info("names = ", names);
            try {
                yield this.client_.deleteMulti(names);
            }
            catch (error) {
                log_2.Log.oth.info("error in delete ", error);
                return false;
            }
            return true;
        });
    }
}
exports.OSSEntity = OSSEntity;
