"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OSSManager = void 0;
const ossEntity_1 = require("./ossEntity");
const config_1 = require("../config");
const log_1 = require("../log");
let ossEntities = new Map();
var OSSManager;
(function (OSSManager) {
    function getEntity(name) {
        if (ossEntities.has(name)) {
            return ossEntities.get(name);
        }
        let config = config_1.Config.localConfig.oss.find(v => v.name == name);
        if (config == null) {
            log_1.Log.oth.info("[OSSMGR] cannot create oss entity name = " + name);
            ossEntities.set(name, null);
            return null;
        }
        let entity = new ossEntity_1.OSSEntity({
            region: config.region,
            bucketName: config.bucketName,
            accessKeyId: config.key,
            accessKeySecret: config.secret,
            cdnPrefix: config.url
        });
        ossEntities.set(name, entity);
        return entity;
    }
    OSSManager.getEntity = getEntity;
})(OSSManager = exports.OSSManager || (exports.OSSManager = {}));
