"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const db_1 = require("../db");
const ServerConfig_1 = require("../../../kds-base-define/src/ServerConfig");
const RoomHelper_1 = require("../helpers/RoomHelper");
const AudioHelper_1 = require("../helpers/AudioHelper");
const rpc_1 = require("../rpc");
const log_1 = require("../log");
let db = db_1.DB.get(ServerConfig_1.ServerValues.dbRoom);
function createLobbyRoom(h, creatorUserID, gameData) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield RoomHelper_1.RoomHelper.createLobbyRoom(creatorUserID, gameData);
    });
}
function createTeaRoom(h, creatorUserID, gameData, teaExt) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield RoomHelper_1.RoomHelper.createTeaRoom(creatorUserID, gameData, teaExt);
    });
}
function createInternalRoom(h, flag, gameData, groupID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield RoomHelper_1.RoomHelper.createInternalRoom(flag, gameData, {
            groupID: groupID
        });
    });
}
function createMatchRoom(h, flag, gameData, matchID) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield RoomHelper_1.RoomHelper.createInternalRoom(flag, gameData, {
            matchID: matchID
        });
    });
}
function removeRoom(h, codeOrID, bill) {
    return __awaiter(this, void 0, void 0, function* () {
        let roomPOData = yield RoomHelper_1.RoomHelper.removeRoom(codeOrID, bill);
        if (roomPOData == null) {
            return false;
        }
        AudioHelper_1.AudioHelper.roomFinished(roomPOData.roomID);
        return true;
    });
}
function removeRoomInternal(h, codeOrID) {
    return __awaiter(this, void 0, void 0, function* () {
        let roomPOData = yield RoomHelper_1.RoomHelper.removeRoomInternal(codeOrID);
        if (roomPOData == null) {
            return false;
        }
        AudioHelper_1.AudioHelper.roomFinished(roomPOData.roomID);
        return true;
    });
}
function uploadAudio(h, roomID, userID, audioFileExt, base64Str) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield AudioHelper_1.AudioHelper.uploadToRoom(roomID, userID, audioFileExt, base64Str);
    });
}
function msgCheck(h, userID, content) {
    return __awaiter(this, void 0, void 0, function* () {
        let areaID = yield rpc_1.Rpc.center.callException("kds.dbp.user.login.getAreaID", userID);
        if (areaID == null) {
            log_1.Log.oth.error("[rpc-room] cannot get user areaID = " + userID);
            return true;
        }
        let gameName = yield rpc_1.Rpc.center.callException("kds.dbp.config.gid.gameName", areaID);
        if (gameName == null) {
            log_1.Log.oth.error("[rpc-room] cannot get gameName areaID = " + areaID);
            return true;
        }
        let b = yield rpc_1.Rpc.center.callException("kds.wechat.room.msgCheck", gameName, content);
        return b;
    });
}
exports.RpcRoom = {
    remove: removeRoom,
    removeInternal: removeRoomInternal,
};
exports.RpcRoomCreate = {
    lobby: createLobbyRoom,
    tea: createTeaRoom,
    internal: createInternalRoom,
    match: createMatchRoom,
};
exports.RpcRoomAudio = {
    upload: uploadAudio
};
