"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const centerClient_1 = require("kdweb-core/lib/rpc/center/centerClient");
const ServerConfig_1 = require("../../kds-base-define/src/ServerConfig");
const config_1 = require("./config");
const realtime_1 = require("./rpc/realtime");
const node_1 = require("./rpc/node");
const room_1 = require("./rpc/room");
const centerNodeRpcEntity_1 = require("./center/centerNodeRpcEntity");
const gs_1 = require("./rpc/gs");
var Rpc;
(function (Rpc) {
    function init() {
        if (ServerConfig_1.ServerValues.localIp) {
            centerClient_1.kdRpcCenterClient.setupLocalHostReplacement(ServerConfig_1.ServerValues.localIp);
        }
        Rpc.center = new centerClient_1.kdRpcCenterClient.entity({
            centerHost: ServerConfig_1.ServerValues.rpcCenterHost,
            port: config_1.Config.myConfig.wsPort,
            token: ServerConfig_1.ServerValues.rpcToken,
            info: {
                name: config_1.Config.myName,
                tag: config_1.Config.myName,
                host: config_1.Config.myConfig.wsHost,
                // auth: "Vash",
                auth: "Vash",
                version: "1.0",
                timestamp: 0,
                data: null
            }
        });
        Rpc.center.logUrlPath = ServerConfig_1.ServerValues.rpcLoggerHost;
        Rpc.center.addGroup("kds.srs.center", realtime_1.RpcSrsRealtime);
        Rpc.center.addGroup("kds.srs.room", room_1.RpcRoom);
        Rpc.center.addGroup("kds.srs.gs", gs_1.RpcGS);
        Rpc.nodeServer = new centerNodeRpcEntity_1.SrsCenterNodeRpcEntity({
            port: config_1.Config.nodeServerConfig.wsPort,
            token: ServerConfig_1.ServerValues.rpcToken,
            info: {
                name: config_1.Config.nodeServerConfig.name,
                tag: config_1.Config.nodeServerConfig.name,
                host: config_1.Config.nodeServerConfig.wsHost,
                // auth: "Vash",
                auth: "Vash",
                version: "1.0",
                timestamp: 0,
                data: null
            }
        });
        Rpc.nodeServer.logUrlPath = ServerConfig_1.ServerValues.rpcLoggerHost;
        Rpc.nodeServer.addGroup("kds.srs-in.centerside", node_1.RpcNodeServer);
    }
    Rpc.init = init;
})(Rpc = exports.Rpc || (exports.Rpc = {}));
