"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const rpc_1 = require("../rpc");
const user_1 = require("../helper/user");
const log_1 = require("../log");
// node 请求 center
function getAllNodes() {
    return __awaiter(this, void 0, void 0, function* () {
        let clients = rpc_1.Rpc.nodeServer.clients;
        return clients;
    });
}
function getAllNodeOtherConfigs() {
    return __awaiter(this, void 0, void 0, function* () {
        // let clients = Rpc.nodeServer.clients
        // return clients
        // let res = await Rpc.nodeServer.callAll(SrsInternal.NodeSide.getOtherConfig)
        // let configs:SrsDefine.NodeOtherConfigType[] = []
        // for(let info of res) {
        // 	if(!info.success) {
        // 		Log.oth.error("[ns-in] get node other config failed name = " + info.clientInfo.name)
        // 	} else {
        // 		configs.push(info.data)
        // 	}
        // }	
        // return configs
        return rpc_1.Rpc.nodeServer.nodeOtherConfigs;
    });
}
function userReg(h, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let client = rpc_1.Rpc.nodeServer.getServerClientInfo(h);
        user_1.UserHelper.regUser(userID, client.name);
        log_1.Log.oth.info("[ns-in] user reg to node userID = " + userID + " node = " + client.name);
    });
}
function userUnReg(h, userID) {
    return __awaiter(this, void 0, void 0, function* () {
        let client = rpc_1.Rpc.nodeServer.getServerClientInfo(h);
        if (user_1.UserHelper.unRegUser(userID, client.name)) {
            log_1.Log.oth.info("[ns-in] user unreg from node userID = " + userID + " node = " + client.name);
        }
        else {
            log_1.Log.oth.info("[ns-in] user unreg failed from node userID = " + userID + " node = " + client.name);
        }
    });
}
exports.RpcNodeServer = {
    getAllNodes,
    getAllNodeOtherConfigs,
    userReg,
    userUnReg
};
