"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const pay_1 = require("../wechat/pay");
const service_1 = require("../wechat/service");
function loginWithCode(h, gameName, code) {
    return __awaiter(this, void 0, void 0, function* () {
        let t = yield service_1.WechatService.loginWithCode(gameName, code);
        return t;
    });
}
exports.RpcWechat = {
    login: loginWithCode,
};
function prepareSelfPay(h, gameName, userID, money, sandBox) {
    return __awaiter(this, void 0, void 0, function* () {
        return pay_1.WechatPay.prepareSelfPay(gameName, userID, money, sandBox);
    });
}
function prepareOtherPay(h, gameName, userID, money, billID, callbackRpcMethod, sandBox) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield pay_1.WechatPay.prepareOtherPay(gameName, userID, money, billID, callbackRpcMethod, sandBox);
    });
}
function getAccount(h, gameName, userID, sandBox) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield pay_1.WechatPay.getAccount(gameName, userID, sandBox);
    });
}
function payMoney(h, gameName, userID, money, content, sandBox) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield pay_1.WechatPay.payMoney(gameName, userID, money, content, sandBox);
    });
}
exports.RpcWechatPay = {
    prepareSelfPay,
    prepareOtherPay,
    getAccount,
    payMoney,
};
