"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const wcore = require("kdweb-core");
const config_1 = require("./config");
const rpc_1 = require("./rpc");
const callback_1 = require("./wechat/callback");
let app = new wcore.service.entity(config_1.Config.myConfig.servicePort);
for (let config of config_1.Config.localConfig.games) {
    if (config.callback) {
        app.addInstance(config.callback.prefix, new callback_1.WechatCallback.Verify(config.gameName));
        app.addInstance(config.callback.prefix, new callback_1.WechatCallback.Service(config.gameName));
    }
}
app.listen();
rpc_1.Rpc.init();
